/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.queryparser.surround.query;

import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.MultiFields;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.index.Terms;
import conductor.org.apache.lucene.index.TermsEnum;
import conductor.org.apache.lucene.queryparser.surround.query.SimpleTerm;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.StringHelper;
import java.io.IOException;

public class SrndPrefixQuery
extends SimpleTerm {
    private final BytesRef prefixRef;
    private final String prefix;
    private final char truncator;

    public SrndPrefixQuery(String prefix, boolean quoted, char truncator) {
        super(quoted);
        this.prefix = prefix;
        this.prefixRef = new BytesRef(prefix);
        this.truncator = truncator;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public char getSuffixOperator() {
        return this.truncator;
    }

    public Term getLucenePrefixTerm(String fieldName) {
        return new Term(fieldName, this.getPrefix());
    }

    @Override
    public String toStringUnquoted() {
        return this.getPrefix();
    }

    @Override
    protected void suffixToString(StringBuilder r) {
        r.append(this.getSuffixOperator());
    }

    @Override
    public void visitMatchingTerms(IndexReader reader, String fieldName, SimpleTerm.MatchingTermVisitor mtv) throws IOException {
        Terms terms = MultiFields.getTerms(reader, fieldName);
        if (terms != null) {
            TermsEnum termsEnum = terms.iterator();
            boolean skip = false;
            TermsEnum.SeekStatus status = termsEnum.seekCeil(new BytesRef(this.getPrefix()));
            if (status == TermsEnum.SeekStatus.FOUND) {
                mtv.visitMatchingTerm(this.getLucenePrefixTerm(fieldName));
            } else if (status == TermsEnum.SeekStatus.NOT_FOUND) {
                if (StringHelper.startsWith(termsEnum.term(), this.prefixRef)) {
                    mtv.visitMatchingTerm(new Term(fieldName, termsEnum.term().utf8ToString()));
                } else {
                    skip = true;
                }
            } else {
                skip = true;
            }
            if (!skip) {
                BytesRef text;
                while ((text = termsEnum.next()) != null && StringHelper.startsWith(text, this.prefixRef)) {
                    mtv.visitMatchingTerm(new Term(fieldName, text.utf8ToString()));
                }
            }
        }
    }
}

