/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.grouping;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.queries.function.FunctionValues;
import conductor.org.apache.lucene.queries.function.ValueSource;
import conductor.org.apache.lucene.search.grouping.GroupSelector;
import conductor.org.apache.lucene.search.grouping.SearchGroup;
import conductor.org.apache.lucene.util.mutable.MutableValue;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ValueSourceGroupSelector
extends GroupSelector<MutableValue> {
    private final ValueSource valueSource;
    private final Map<?, ?> context;
    private Set<MutableValue> secondPassGroups;
    private FunctionValues.ValueFiller filler;

    public ValueSourceGroupSelector(ValueSource valueSource, Map<?, ?> context) {
        this.valueSource = valueSource;
        this.context = context;
    }

    @Override
    public void setNextReader(LeafReaderContext readerContext) throws IOException {
        FunctionValues values = this.valueSource.getValues(this.context, readerContext);
        this.filler = values.getValueFiller();
    }

    @Override
    public GroupSelector.State advanceTo(int doc) throws IOException {
        this.filler.fillValue(doc);
        if (this.secondPassGroups != null && !this.secondPassGroups.contains(this.filler.getValue())) {
            return GroupSelector.State.SKIP;
        }
        return GroupSelector.State.ACCEPT;
    }

    @Override
    public MutableValue currentValue() {
        return this.filler.getValue();
    }

    @Override
    public MutableValue copyValue() {
        return this.filler.getValue().duplicate();
    }

    @Override
    public void setGroups(Collection<SearchGroup<MutableValue>> searchGroups) {
        this.secondPassGroups = new HashSet<MutableValue>();
        for (SearchGroup<MutableValue> group : searchGroups) {
            this.secondPassGroups.add((MutableValue)group.groupValue);
        }
    }
}

