/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.suggest.document;

import conductor.org.apache.lucene.codecs.FieldsConsumer;
import conductor.org.apache.lucene.codecs.FieldsProducer;
import conductor.org.apache.lucene.codecs.PostingsFormat;
import conductor.org.apache.lucene.index.SegmentReadState;
import conductor.org.apache.lucene.index.SegmentWriteState;
import conductor.org.apache.lucene.search.suggest.document.CompletionFieldsConsumer;
import conductor.org.apache.lucene.search.suggest.document.CompletionFieldsProducer;
import java.io.IOException;

public abstract class CompletionPostingsFormat
extends PostingsFormat {
    static final String CODEC_NAME = "completion";
    static final int COMPLETION_CODEC_VERSION = 1;
    static final int COMPLETION_VERSION_CURRENT = 1;
    static final String INDEX_EXTENSION = "cmp";
    static final String DICT_EXTENSION = "lkp";

    public CompletionPostingsFormat() {
        super(CODEC_NAME);
    }

    protected abstract PostingsFormat delegatePostingsFormat();

    @Override
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        PostingsFormat delegatePostingsFormat = this.delegatePostingsFormat();
        if (delegatePostingsFormat == null) {
            throw new UnsupportedOperationException("Error - " + this.getClass().getName() + " has been constructed without a choice of PostingsFormat");
        }
        return new CompletionFieldsConsumer(delegatePostingsFormat, state);
    }

    @Override
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new CompletionFieldsProducer(state);
    }
}

