/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.spatial.prefix;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.search.DocIdSet;
import conductor.org.apache.lucene.spatial.prefix.AbstractVisitingPrefixTreeQuery;
import conductor.org.apache.lucene.spatial.prefix.tree.Cell;
import conductor.org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import conductor.org.apache.lucene.util.DocIdSetBuilder;
import java.io.IOException;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.SpatialRelation;

public class IntersectsPrefixTreeQuery
extends AbstractVisitingPrefixTreeQuery {
    public IntersectsPrefixTreeQuery(Shape queryShape, String fieldName, SpatialPrefixTree grid, int detailLevel, int prefixGridScanLevel) {
        super(queryShape, fieldName, grid, detailLevel, prefixGridScanLevel);
    }

    @Override
    protected DocIdSet getDocIdSet(LeafReaderContext context) throws IOException {
        return new AbstractVisitingPrefixTreeQuery.VisitorTemplate(context){
            private DocIdSetBuilder results;

            @Override
            protected void start() throws IOException {
                this.results = new DocIdSetBuilder(this.maxDoc, this.terms);
            }

            @Override
            protected DocIdSet finish() {
                return this.results.build();
            }

            @Override
            protected boolean visitPrefix(Cell cell) throws IOException {
                if (cell.getShapeRel() == SpatialRelation.WITHIN || cell.getLevel() == IntersectsPrefixTreeQuery.this.detailLevel) {
                    this.collectDocs(this.results);
                    return false;
                }
                return true;
            }

            @Override
            protected void visitLeaf(Cell cell) throws IOException {
                this.collectDocs(this.results);
            }
        }.getDocIdSet();
    }

    @Override
    public String toString(String field) {
        return this.getClass().getSimpleName() + "(fieldName=" + this.fieldName + ",queryShape=" + this.queryShape + ",detailLevel=" + this.detailLevel + ",prefixGridScanLevel=" + this.prefixGridScanLevel + ")";
    }
}

