/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.util;

import conductor.org.apache.lucene.util.ArrayUtil;
import java.util.Arrays;

public final class LongsRef
implements Comparable<LongsRef>,
Cloneable {
    public static final long[] EMPTY_LONGS = new long[0];
    public long[] longs;
    public int offset;
    public int length;

    public LongsRef() {
        this.longs = EMPTY_LONGS;
    }

    public LongsRef(int capacity) {
        this.longs = new long[capacity];
    }

    public LongsRef(long[] longs, int offset, int length) {
        this.longs = longs;
        this.offset = offset;
        this.length = length;
        assert (this.isValid());
    }

    public LongsRef clone() {
        return new LongsRef(this.longs, this.offset, this.length);
    }

    public int hashCode() {
        int prime = 31;
        int result = 0;
        long end = this.offset + this.length;
        int i = this.offset;
        while ((long)i < end) {
            result = 31 * result + (int)(this.longs[i] ^ this.longs[i] >>> 32);
            ++i;
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof LongsRef) {
            return this.longsEquals((LongsRef)other);
        }
        return false;
    }

    public boolean longsEquals(LongsRef other) {
        return Arrays.equals(this.longs, this.offset, this.offset + this.length, other.longs, other.offset, other.offset + other.length);
    }

    @Override
    public int compareTo(LongsRef other) {
        return Arrays.compare(this.longs, this.offset, this.offset + this.length, other.longs, other.offset, other.offset + other.length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        long end = this.offset + this.length;
        int i = this.offset;
        while ((long)i < end) {
            if (i > this.offset) {
                sb.append(' ');
            }
            sb.append(Long.toHexString(this.longs[i]));
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    public static LongsRef deepCopyOf(LongsRef other) {
        return new LongsRef(ArrayUtil.copyOfSubArray(other.longs, other.offset, other.offset + other.length), 0, other.length);
    }

    public boolean isValid() {
        if (this.longs == null) {
            throw new IllegalStateException("longs is null");
        }
        if (this.length < 0) {
            throw new IllegalStateException("length is negative: " + this.length);
        }
        if (this.length > this.longs.length) {
            throw new IllegalStateException("length is out of bounds: " + this.length + ",longs.length=" + this.longs.length);
        }
        if (this.offset < 0) {
            throw new IllegalStateException("offset is negative: " + this.offset);
        }
        if (this.offset > this.longs.length) {
            throw new IllegalStateException("offset out of bounds: " + this.offset + ",longs.length=" + this.longs.length);
        }
        if (this.offset + this.length < 0) {
            throw new IllegalStateException("offset+length is negative: offset=" + this.offset + ",length=" + this.length);
        }
        if (this.offset + this.length > this.longs.length) {
            throw new IllegalStateException("offset+length out of bounds: offset=" + this.offset + ",length=" + this.length + ",longs.length=" + this.longs.length);
        }
        return true;
    }
}

