/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.util.bkd;

import conductor.org.apache.lucene.codecs.MutablePointValues;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.FutureArrays;
import conductor.org.apache.lucene.util.IntroSelector;
import conductor.org.apache.lucene.util.IntroSorter;
import conductor.org.apache.lucene.util.MSBRadixSorter;
import conductor.org.apache.lucene.util.RadixSelector;
import conductor.org.apache.lucene.util.Selector;
import conductor.org.apache.lucene.util.Sorter;
import conductor.org.apache.lucene.util.packed.PackedInts;

public final class MutablePointsReaderUtils {
    MutablePointsReaderUtils() {
    }

    public static void sort(int maxDoc, final int packedBytesLength, final MutablePointValues reader, int from, int to) {
        final int bitsPerDocId = PackedInts.bitsRequired(maxDoc - 1);
        new MSBRadixSorter(packedBytesLength + (bitsPerDocId + 7) / 8){

            @Override
            protected void swap(int i, int j) {
                reader.swap(i, j);
            }

            @Override
            protected int byteAt(int i, int k) {
                if (k < packedBytesLength) {
                    return Byte.toUnsignedInt(reader.getByteAt(i, k));
                }
                int shift = bitsPerDocId - (k - packedBytesLength + 1 << 3);
                return reader.getDocID(i) >>> Math.max(0, shift) & 0xFF;
            }

            @Override
            protected Sorter getFallbackSorter(final int k) {
                return new IntroSorter(){
                    final BytesRef pivot = new BytesRef();
                    final BytesRef scratch = new BytesRef();
                    int pivotDoc;

                    @Override
                    protected void swap(int i, int j) {
                        reader.swap(i, j);
                    }

                    @Override
                    protected void setPivot(int i) {
                        reader.getValue(i, this.pivot);
                        this.pivotDoc = reader.getDocID(i);
                    }

                    @Override
                    protected int comparePivot(int j) {
                        if (k < packedBytesLength) {
                            reader.getValue(j, this.scratch);
                            int cmp = FutureArrays.compareUnsigned(this.pivot.bytes, this.pivot.offset + k, this.pivot.offset + k + packedBytesLength - k, this.scratch.bytes, this.scratch.offset + k, this.scratch.offset + k + packedBytesLength - k);
                            if (cmp != 0) {
                                return cmp;
                            }
                        }
                        return this.pivotDoc - reader.getDocID(j);
                    }
                };
            }
        }.sort(from, to);
    }

    public static void sortByDim(int sortedDim, int bytesPerDim, int[] commonPrefixLengths, final MutablePointValues reader, int from, int to, final BytesRef scratch1, final BytesRef scratch2) {
        final int offset = sortedDim * bytesPerDim + commonPrefixLengths[sortedDim];
        final int numBytesToCompare = bytesPerDim - commonPrefixLengths[sortedDim];
        new IntroSorter(){
            final BytesRef pivot;
            int pivotDoc;
            {
                this.pivot = scratch1;
                this.pivotDoc = -1;
            }

            @Override
            protected void swap(int i, int j) {
                reader.swap(i, j);
            }

            @Override
            protected void setPivot(int i) {
                reader.getValue(i, this.pivot);
                this.pivotDoc = reader.getDocID(i);
            }

            @Override
            protected int comparePivot(int j) {
                reader.getValue(j, scratch2);
                int cmp = FutureArrays.compareUnsigned(this.pivot.bytes, this.pivot.offset + offset, this.pivot.offset + offset + numBytesToCompare, scratch2.bytes, scratch2.offset + offset, scratch2.offset + offset + numBytesToCompare);
                if (cmp == 0) {
                    cmp = this.pivotDoc - reader.getDocID(j);
                }
                return cmp;
            }
        }.sort(from, to);
    }

    public static void partition(int maxDoc, int splitDim, int bytesPerDim, int commonPrefixLen, final MutablePointValues reader, int from, int to, int mid, final BytesRef scratch1, final BytesRef scratch2) {
        final int offset = splitDim * bytesPerDim + commonPrefixLen;
        final int cmpBytes = bytesPerDim - commonPrefixLen;
        final int bitsPerDocId = PackedInts.bitsRequired(maxDoc - 1);
        new RadixSelector(cmpBytes + (bitsPerDocId + 7) / 8){

            @Override
            protected Selector getFallbackSelector(final int k) {
                return new IntroSelector(){
                    final BytesRef pivot;
                    int pivotDoc;
                    {
                        this.pivot = scratch1;
                    }

                    @Override
                    protected void swap(int i, int j) {
                        reader.swap(i, j);
                    }

                    @Override
                    protected void setPivot(int i) {
                        reader.getValue(i, this.pivot);
                        this.pivotDoc = reader.getDocID(i);
                    }

                    @Override
                    protected int comparePivot(int j) {
                        if (k < cmpBytes) {
                            reader.getValue(j, scratch2);
                            int cmp = FutureArrays.compareUnsigned(this.pivot.bytes, this.pivot.offset + offset + k, this.pivot.offset + offset + k + cmpBytes - k, scratch2.bytes, scratch2.offset + offset + k, scratch2.offset + offset + k + cmpBytes - k);
                            if (cmp != 0) {
                                return cmp;
                            }
                        }
                        return this.pivotDoc - reader.getDocID(j);
                    }
                };
            }

            @Override
            protected void swap(int i, int j) {
                reader.swap(i, j);
            }

            @Override
            protected int byteAt(int i, int k) {
                if (k < cmpBytes) {
                    return Byte.toUnsignedInt(reader.getByteAt(i, offset + k));
                }
                int shift = bitsPerDocId - (k - cmpBytes + 1 << 3);
                return reader.getDocID(i) >>> Math.max(0, shift) & 0xFF;
            }
        }.select(from, to, mid);
    }
}

