/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.ActionListenerResponseHandler;
import conductor.org.elasticsearch.action.ActionRequest;
import conductor.org.elasticsearch.action.ActionRequestValidationException;
import conductor.org.elasticsearch.action.ActionResponse;
import conductor.org.elasticsearch.action.GenericAction;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.transport.TransportRequest;
import conductor.org.elasticsearch.transport.TransportRequestOptions;
import conductor.org.elasticsearch.transport.TransportService;

public class TransportActionNodeProxy<Request extends ActionRequest, Response extends ActionResponse> {
    private final TransportService transportService;
    private final GenericAction<Request, Response> action;
    private final TransportRequestOptions transportOptions;

    public TransportActionNodeProxy(Settings settings, GenericAction<Request, Response> action, TransportService transportService) {
        this.action = action;
        this.transportService = transportService;
        this.transportOptions = action.transportOptions(settings);
    }

    public void execute(DiscoveryNode node, Request request, ActionListener<Response> listener) {
        ActionRequestValidationException validationException = ((ActionRequest)request).validate();
        if (validationException != null) {
            listener.onFailure(validationException);
            return;
        }
        this.transportService.sendRequest(node, this.action.name(), (TransportRequest)request, this.transportOptions, new ActionListenerResponseHandler<Response>(listener, this.action.getResponseReader()));
    }
}

