/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.node.tasks.get;

import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.ResourceNotFoundException;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.cluster.node.tasks.get.GetTaskRequest;
import conductor.org.elasticsearch.action.admin.cluster.node.tasks.get.GetTaskResponse;
import conductor.org.elasticsearch.action.admin.cluster.node.tasks.list.TransportListTasksAction;
import conductor.org.elasticsearch.action.get.GetRequest;
import conductor.org.elasticsearch.action.get.GetResponse;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.HandledTransportAction;
import conductor.org.elasticsearch.client.Client;
import conductor.org.elasticsearch.client.OriginSettingClient;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.util.concurrent.AbstractRunnable;
import conductor.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.common.xcontent.XContentHelper;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.index.IndexNotFoundException;
import conductor.org.elasticsearch.tasks.Task;
import conductor.org.elasticsearch.tasks.TaskInfo;
import conductor.org.elasticsearch.tasks.TaskResult;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportException;
import conductor.org.elasticsearch.transport.TransportRequest;
import conductor.org.elasticsearch.transport.TransportRequestOptions;
import conductor.org.elasticsearch.transport.TransportResponseHandler;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.IOException;

public class TransportGetTaskAction
extends HandledTransportAction<GetTaskRequest, GetTaskResponse> {
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public TransportGetTaskAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, Client client, NamedXContentRegistry xContentRegistry) {
        super(settings, "cluster:monitor/task/get", threadPool, transportService, actionFilters, indexNameExpressionResolver, GetTaskRequest::new);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.client = new OriginSettingClient(client, "tasks");
        this.xContentRegistry = xContentRegistry;
    }

    @Override
    protected void doExecute(GetTaskRequest request, ActionListener<GetTaskResponse> listener) {
        throw new UnsupportedOperationException("Task is required");
    }

    @Override
    protected void doExecute(Task thisTask, GetTaskRequest request, ActionListener<GetTaskResponse> listener) {
        if (this.clusterService.localNode().getId().equals(request.getTaskId().getNodeId())) {
            this.getRunningTaskFromNode(thisTask, request, listener);
        } else {
            this.runOnNodeWithTaskIfPossible(thisTask, request, listener);
        }
    }

    private void runOnNodeWithTaskIfPossible(Task thisTask, GetTaskRequest request, final ActionListener<GetTaskResponse> listener) {
        DiscoveryNode node;
        TransportRequestOptions.Builder builder = TransportRequestOptions.builder();
        if (request.getTimeout() != null) {
            builder.withTimeout(request.getTimeout());
        }
        if ((node = this.clusterService.state().nodes().get(request.getTaskId().getNodeId())) == null) {
            this.getFinishedTaskFromIndex(thisTask, request, ActionListener.wrap(listener::onResponse, e -> {
                if (e instanceof ResourceNotFoundException) {
                    e = new ResourceNotFoundException("task [" + request.getTaskId() + "] belongs to the node [" + request.getTaskId().getNodeId() + "] which isn't part of the cluster and there is no record of the task", (Throwable)e, new Object[0]);
                }
                listener.onFailure((Exception)e);
            }));
            return;
        }
        GetTaskRequest nodeRequest = request.nodeRequest(this.clusterService.localNode().getId(), thisTask.getId());
        this.transportService.sendRequest(node, "cluster:monitor/task/get", (TransportRequest)nodeRequest, builder.build(), new TransportResponseHandler<GetTaskResponse>(){

            @Override
            public GetTaskResponse read(StreamInput in) throws IOException {
                GetTaskResponse response = new GetTaskResponse();
                response.readFrom(in);
                return response;
            }

            @Override
            public void handleResponse(GetTaskResponse response) {
                listener.onResponse(response);
            }

            @Override
            public void handleException(TransportException exp) {
                listener.onFailure(exp);
            }

            @Override
            public String executor() {
                return "same";
            }
        });
    }

    void getRunningTaskFromNode(final Task thisTask, final GetTaskRequest request, final ActionListener<GetTaskResponse> listener) {
        final Task runningTask = this.taskManager.getTask(request.getTaskId().getId());
        if (runningTask == null) {
            this.getFinishedTaskFromIndex(thisTask, request, listener);
        } else if (request.getWaitForCompletion()) {
            this.threadPool.generic().execute(new AbstractRunnable(){

                @Override
                protected void doRun() throws Exception {
                    TransportGetTaskAction.this.taskManager.waitForTaskCompletion(runningTask, TransportListTasksAction.waitForCompletionTimeout(request.getTimeout()));
                    TransportGetTaskAction.this.waitedForCompletion(thisTask, request, runningTask.taskInfo(TransportGetTaskAction.this.clusterService.localNode().getId(), true), listener);
                }

                @Override
                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        } else {
            TaskInfo info = runningTask.taskInfo(this.clusterService.localNode().getId(), true);
            listener.onResponse(new GetTaskResponse(new TaskResult(false, info)));
        }
    }

    void waitedForCompletion(Task thisTask, GetTaskRequest request, final TaskInfo snapshotOfRunningTask, final ActionListener<GetTaskResponse> listener) {
        this.getFinishedTaskFromIndex(thisTask, request, new ActionListener<GetTaskResponse>(){

            @Override
            public void onResponse(GetTaskResponse response) {
                listener.onResponse(response);
            }

            @Override
            public void onFailure(Exception e) {
                if (ExceptionsHelper.unwrap(e, ResourceNotFoundException.class) != null) {
                    listener.onResponse(new GetTaskResponse(new TaskResult(true, snapshotOfRunningTask)));
                } else {
                    listener.onFailure(e);
                }
            }
        });
    }

    void getFinishedTaskFromIndex(Task thisTask, final GetTaskRequest request, final ActionListener<GetTaskResponse> listener) {
        GetRequest get = new GetRequest(".tasks", "task", request.getTaskId().toString());
        get.setParentTask(this.clusterService.localNode().getId(), thisTask.getId());
        this.client.get(get, new ActionListener<GetResponse>(){

            @Override
            public void onResponse(GetResponse getResponse) {
                try {
                    TransportGetTaskAction.this.onGetFinishedTaskFromIndex(getResponse, listener);
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                if (ExceptionsHelper.unwrap(e, IndexNotFoundException.class) != null) {
                    listener.onFailure(new ResourceNotFoundException("task [{}] isn't running and hasn't stored its results", (Throwable)e, request.getTaskId()));
                } else {
                    listener.onFailure(e);
                }
            }
        });
    }

    void onGetFinishedTaskFromIndex(GetResponse response, ActionListener<GetTaskResponse> listener) throws IOException {
        if (!response.isExists()) {
            listener.onFailure(new ResourceNotFoundException("task [{}] isn't running and hasn't stored its results", response.getId()));
            return;
        }
        if (response.isSourceEmpty()) {
            listener.onFailure(new ElasticsearchException("Stored task status for [{}] didn't contain any source!", response.getId()));
            return;
        }
        try (XContentParser parser = XContentHelper.createParser(this.xContentRegistry, LoggingDeprecationHandler.INSTANCE, response.getSourceAsBytesRef());){
            TaskResult result = TaskResult.PARSER.apply(parser, null);
            listener.onResponse(new GetTaskResponse(result));
        }
    }
}

