/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.repositories.get;

import conductor.org.elasticsearch.action.ActionRequestValidationException;
import conductor.org.elasticsearch.action.ValidateActions;
import conductor.org.elasticsearch.action.support.master.MasterNodeReadRequest;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import java.io.IOException;

public class GetRepositoriesRequest
extends MasterNodeReadRequest<GetRepositoriesRequest> {
    private String[] repositories = Strings.EMPTY_ARRAY;

    public GetRepositoriesRequest() {
    }

    public GetRepositoriesRequest(String[] repositories) {
        this.repositories = repositories;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.repositories == null) {
            validationException = ValidateActions.addValidationError("repositories is null", validationException);
        }
        return validationException;
    }

    public String[] repositories() {
        return this.repositories;
    }

    public GetRepositoriesRequest repositories(String[] repositories) {
        this.repositories = repositories;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.repositories = in.readStringArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.repositories);
    }
}

