/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.shards;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.ActionRequestValidationException;
import conductor.org.elasticsearch.action.IndicesRequest;
import conductor.org.elasticsearch.action.support.IndicesOptions;
import conductor.org.elasticsearch.action.support.master.MasterNodeReadRequest;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import java.io.IOException;
import java.util.Objects;

public class ClusterSearchShardsRequest
extends MasterNodeReadRequest<ClusterSearchShardsRequest>
implements IndicesRequest.Replaceable {
    private String[] indices = Strings.EMPTY_ARRAY;
    @Nullable
    private String routing;
    @Nullable
    private String preference;
    private IndicesOptions indicesOptions = IndicesOptions.lenientExpandOpen();

    public ClusterSearchShardsRequest() {
    }

    public ClusterSearchShardsRequest(String ... indices) {
        this.indices(indices);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public ClusterSearchShardsRequest indices(String ... indices) {
        Objects.requireNonNull(indices, "indices must not be null");
        for (int i = 0; i < indices.length; ++i) {
            Objects.requireNonNull(indices[i], "indices[" + i + "] must not be null");
        }
        this.indices = indices;
        return this;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public ClusterSearchShardsRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public ClusterSearchShardsRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public ClusterSearchShardsRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString(routings);
        return this;
    }

    public ClusterSearchShardsRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = new String[in.readVInt()];
        for (int i = 0; i < this.indices.length; ++i) {
            this.indices[i] = in.readString();
        }
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        if (in.getVersion().onOrBefore(Version.V_5_1_1)) {
            in.readStringArray();
        }
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.indices.length);
        for (String index : this.indices) {
            out.writeString(index);
        }
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        if (out.getVersion().onOrBefore(Version.V_5_1_1)) {
            out.writeStringArray(Strings.EMPTY_ARRAY);
        }
        this.indicesOptions.writeIndicesOptions(out);
    }
}

