/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.indices.close;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.indices.flush.FlushRequest;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.replication.ReplicationOperation;
import conductor.org.elasticsearch.action.support.replication.ReplicationRequest;
import conductor.org.elasticsearch.action.support.replication.ReplicationResponse;
import conductor.org.elasticsearch.action.support.replication.TransportReplicationAction;
import conductor.org.elasticsearch.cluster.action.shard.ShardStateAction;
import conductor.org.elasticsearch.cluster.block.ClusterBlock;
import conductor.org.elasticsearch.cluster.block.ClusterBlocks;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.lease.Releasable;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.index.shard.IndexShard;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.indices.IndicesService;
import conductor.org.elasticsearch.tasks.TaskId;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.IOException;
import java.util.Objects;

public class TransportVerifyShardBeforeCloseAction
extends TransportReplicationAction<ShardRequest, ShardRequest, ReplicationResponse> {
    public static final String NAME = "indices:admin/close[s]";
    protected Logger logger = LogManager.getLogger(this.getClass());

    @Inject
    public TransportVerifyShardBeforeCloseAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction stateAction, ActionFilters actionFilters, IndexNameExpressionResolver resolver) {
        super(settings, NAME, transportService, clusterService, indicesService, threadPool, stateAction, actionFilters, resolver, ShardRequest::new, ShardRequest::new, "management");
    }

    @Override
    protected ReplicationResponse newResponseInstance() {
        return new ReplicationResponse();
    }

    @Override
    protected void acquirePrimaryOperationPermit(IndexShard primary, ShardRequest request, ActionListener<Releasable> onAcquired) {
        primary.acquireAllPrimaryOperationsPermits(onAcquired, request.timeout());
    }

    @Override
    protected void acquireReplicaOperationPermit(IndexShard replica, ShardRequest request, ActionListener<Releasable> onAcquired, long primaryTerm, long globalCheckpoint, long maxSeqNoOfUpdateOrDeletes) {
        replica.acquireAllReplicaOperationsPermits(primaryTerm, globalCheckpoint, maxSeqNoOfUpdateOrDeletes, onAcquired, request.timeout());
    }

    @Override
    protected TransportReplicationAction.PrimaryResult<ShardRequest, ReplicationResponse> shardOperationOnPrimary(ShardRequest shardRequest, IndexShard primary) throws Exception {
        this.executeShardOperation(shardRequest, primary);
        return new TransportReplicationAction.PrimaryResult<ShardRequest, ReplicationResponse>(shardRequest, new ReplicationResponse());
    }

    @Override
    protected TransportReplicationAction.ReplicaResult shardOperationOnReplica(ShardRequest shardRequest, IndexShard replica) throws Exception {
        this.executeShardOperation(shardRequest, replica);
        return new TransportReplicationAction.ReplicaResult();
    }

    private void executeShardOperation(ShardRequest request, IndexShard indexShard) {
        ShardId shardId = indexShard.shardId();
        if (indexShard.getActiveOperationsCount() != 0) {
            throw new IllegalStateException("On-going operations in progress while checking index shard " + shardId + " before closing");
        }
        ClusterBlocks clusterBlocks = this.clusterService.state().blocks();
        if (!clusterBlocks.hasIndexBlock(shardId.getIndexName(), request.clusterBlock())) {
            throw new IllegalStateException("Index shard " + shardId + " must be blocked by " + request.clusterBlock() + " before closing");
        }
        indexShard.verifyShardBeforeIndexClosing();
        indexShard.flush(new FlushRequest(new String[0]).force(true));
        this.logger.trace("{} shard is ready for closing", (Object)shardId);
    }

    @Override
    protected ReplicationOperation.Replicas<ShardRequest> newReplicasProxy(long primaryTerm) {
        return new VerifyShardBeforeCloseActionReplicasProxy(primaryTerm);
    }

    public static class ShardRequest
    extends ReplicationRequest<ShardRequest> {
        private ClusterBlock clusterBlock;

        ShardRequest() {
        }

        public ShardRequest(ShardId shardId, ClusterBlock clusterBlock, TaskId parentTaskId) {
            super(shardId);
            this.clusterBlock = Objects.requireNonNull(clusterBlock);
            this.setParentTask(parentTaskId);
        }

        @Override
        public String toString() {
            return "verify shard " + this.shardId + " before close with block " + this.clusterBlock;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.clusterBlock = ClusterBlock.readClusterBlock(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.clusterBlock.writeTo(out);
        }

        public ClusterBlock clusterBlock() {
            return this.clusterBlock;
        }
    }

    class VerifyShardBeforeCloseActionReplicasProxy
    extends TransportReplicationAction.ReplicasProxy {
        VerifyShardBeforeCloseActionReplicasProxy(long primaryTerm) {
            super(primaryTerm);
        }

        @Override
        public void markShardCopyAsStaleIfNeeded(ShardId shardId, String allocationId, ActionListener<Void> listener) {
            TransportVerifyShardBeforeCloseAction.this.shardStateAction.remoteShardFailed(shardId, allocationId, this.primaryTerm, true, "mark copy as stale", null, listener);
        }
    }
}

