/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.bulk;

import conductor.org.elasticsearch.action.DocWriteResponse;
import conductor.org.elasticsearch.action.bulk.BulkItemResponse;
import conductor.org.elasticsearch.action.support.WriteResponse;
import conductor.org.elasticsearch.action.support.replication.ReplicationResponse;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.index.shard.ShardId;
import java.io.IOException;

public class BulkShardResponse
extends ReplicationResponse
implements WriteResponse {
    private ShardId shardId;
    private BulkItemResponse[] responses;

    BulkShardResponse() {
    }

    public BulkShardResponse(ShardId shardId, BulkItemResponse[] responses) {
        this.shardId = shardId;
        this.responses = responses;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public BulkItemResponse[] getResponses() {
        return this.responses;
    }

    @Override
    public void setForcedRefresh(boolean forcedRefresh) {
        for (BulkItemResponse response : this.responses) {
            Object r = response.getResponse();
            if (r == null) continue;
            ((DocWriteResponse)r).setForcedRefresh(forcedRefresh);
        }
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardId = ShardId.readShardId(in);
        this.responses = new BulkItemResponse[in.readVInt()];
        for (int i = 0; i < this.responses.length; ++i) {
            this.responses[i] = BulkItemResponse.readBulkItem(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardId.writeTo(out);
        out.writeVInt(this.responses.length);
        for (BulkItemResponse response : this.responses) {
            response.writeTo(out);
        }
    }
}

