/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.ingest;

import conductor.org.elasticsearch.action.Action;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.ActionListenerResponseHandler;
import conductor.org.elasticsearch.action.ActionRequest;
import conductor.org.elasticsearch.cluster.ClusterChangedEvent;
import conductor.org.elasticsearch.cluster.ClusterStateApplier;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.common.Randomness;
import conductor.org.elasticsearch.transport.TransportService;
import java.util.concurrent.atomic.AtomicInteger;

public final class IngestActionForwarder
implements ClusterStateApplier {
    private final TransportService transportService;
    private final AtomicInteger ingestNodeGenerator = new AtomicInteger(Randomness.get().nextInt());
    private DiscoveryNode[] ingestNodes;

    public IngestActionForwarder(TransportService transportService) {
        this.transportService = transportService;
        this.ingestNodes = new DiscoveryNode[0];
    }

    public void forwardIngestRequest(Action<?, ?, ?> action, ActionRequest request, ActionListener<?> listener) {
        this.transportService.sendRequest(this.randomIngestNode(), action.name(), request, new ActionListenerResponseHandler(listener, action.getResponseReader()));
    }

    private DiscoveryNode randomIngestNode() {
        DiscoveryNode[] nodes = this.ingestNodes;
        if (nodes.length == 0) {
            throw new IllegalStateException("There are no ingest nodes in this cluster, unable to forward request to an ingest node.");
        }
        return nodes[Math.floorMod(this.ingestNodeGenerator.incrementAndGet(), nodes.length)];
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        this.ingestNodes = event.state().getNodes().getIngestNodes().values().toArray(DiscoveryNode.class);
    }
}

