/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.search;

import conductor.org.elasticsearch.action.OriginalIndices;
import conductor.org.elasticsearch.cluster.routing.PlainShardIterator;
import conductor.org.elasticsearch.cluster.routing.ShardRouting;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.search.SearchShardTarget;
import java.util.List;

public final class SearchShardIterator
extends PlainShardIterator {
    private final OriginalIndices originalIndices;
    private final String clusterAlias;
    private boolean skip = false;

    public SearchShardIterator(@Nullable String clusterAlias, ShardId shardId, List<ShardRouting> shards, OriginalIndices originalIndices) {
        super(shardId, shards);
        this.originalIndices = originalIndices;
        this.clusterAlias = clusterAlias;
    }

    public OriginalIndices getOriginalIndices() {
        return this.originalIndices;
    }

    @Nullable
    public String getClusterAlias() {
        return this.clusterAlias;
    }

    SearchShardTarget newSearchShardTarget(String nodeId) {
        return new SearchShardTarget(nodeId, this.shardId(), this.clusterAlias, this.originalIndices);
    }

    void resetAndSkip() {
        this.reset();
        this.skip = true;
    }

    boolean skip() {
        return this.skip;
    }
}

