/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.search;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.ActionListenerResponseHandler;
import conductor.org.elasticsearch.action.IndicesRequest;
import conductor.org.elasticsearch.action.OriginalIndices;
import conductor.org.elasticsearch.action.search.MultiSearchRequest;
import conductor.org.elasticsearch.action.search.MultiSearchResponse;
import conductor.org.elasticsearch.action.search.SearchActionListener;
import conductor.org.elasticsearch.action.search.SearchTask;
import conductor.org.elasticsearch.action.support.ChannelActionListener;
import conductor.org.elasticsearch.action.support.IndicesOptions;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import conductor.org.elasticsearch.search.SearchPhaseResult;
import conductor.org.elasticsearch.search.SearchService;
import conductor.org.elasticsearch.search.dfs.DfsSearchResult;
import conductor.org.elasticsearch.search.fetch.FetchSearchResult;
import conductor.org.elasticsearch.search.fetch.QueryFetchSearchResult;
import conductor.org.elasticsearch.search.fetch.ScrollQueryFetchSearchResult;
import conductor.org.elasticsearch.search.fetch.ShardFetchRequest;
import conductor.org.elasticsearch.search.fetch.ShardFetchSearchRequest;
import conductor.org.elasticsearch.search.internal.InternalScrollSearchRequest;
import conductor.org.elasticsearch.search.internal.ShardSearchRequest;
import conductor.org.elasticsearch.search.internal.ShardSearchTransportRequest;
import conductor.org.elasticsearch.search.query.QuerySearchRequest;
import conductor.org.elasticsearch.search.query.QuerySearchResult;
import conductor.org.elasticsearch.search.query.ScrollQuerySearchResult;
import conductor.org.elasticsearch.tasks.Task;
import conductor.org.elasticsearch.transport.RemoteClusterService;
import conductor.org.elasticsearch.transport.TaskAwareTransportRequestHandler;
import conductor.org.elasticsearch.transport.Transport;
import conductor.org.elasticsearch.transport.TransportActionProxy;
import conductor.org.elasticsearch.transport.TransportChannel;
import conductor.org.elasticsearch.transport.TransportException;
import conductor.org.elasticsearch.transport.TransportRequest;
import conductor.org.elasticsearch.transport.TransportRequestOptions;
import conductor.org.elasticsearch.transport.TransportResponse;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class SearchTransportService {
    public static final String FREE_CONTEXT_SCROLL_ACTION_NAME = "indices:data/read/search[free_context/scroll]";
    public static final String FREE_CONTEXT_ACTION_NAME = "indices:data/read/search[free_context]";
    public static final String CLEAR_SCROLL_CONTEXTS_ACTION_NAME = "indices:data/read/search[clear_scroll_contexts]";
    public static final String DFS_ACTION_NAME = "indices:data/read/search[phase/dfs]";
    public static final String QUERY_ACTION_NAME = "indices:data/read/search[phase/query]";
    public static final String QUERY_ID_ACTION_NAME = "indices:data/read/search[phase/query/id]";
    public static final String QUERY_SCROLL_ACTION_NAME = "indices:data/read/search[phase/query/scroll]";
    public static final String QUERY_FETCH_SCROLL_ACTION_NAME = "indices:data/read/search[phase/query+fetch/scroll]";
    public static final String FETCH_ID_SCROLL_ACTION_NAME = "indices:data/read/search[phase/fetch/id/scroll]";
    public static final String FETCH_ID_ACTION_NAME = "indices:data/read/search[phase/fetch/id]";
    public static final String QUERY_CAN_MATCH_NAME = "indices:data/read/search[can_match]";
    private final TransportService transportService;
    private final BiFunction<Transport.Connection, SearchActionListener, ActionListener> responseWrapper;
    private final Map<String, Long> clientConnections = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();

    public SearchTransportService(TransportService transportService, BiFunction<Transport.Connection, SearchActionListener, ActionListener> responseWrapper) {
        this.transportService = transportService;
        this.responseWrapper = responseWrapper;
    }

    public void sendFreeContext(Transport.Connection connection, long contextId, OriginalIndices originalIndices) {
        this.transportService.sendRequest(connection, FREE_CONTEXT_ACTION_NAME, (TransportRequest)new SearchFreeContextRequest(originalIndices, contextId), TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<SearchFreeContextResponse>(new ActionListener<SearchFreeContextResponse>(){

            @Override
            public void onResponse(SearchFreeContextResponse response) {
            }

            @Override
            public void onFailure(Exception e) {
            }
        }, SearchFreeContextResponse::new));
    }

    public void sendFreeContext(Transport.Connection connection, long contextId, ActionListener<SearchFreeContextResponse> listener) {
        this.transportService.sendRequest(connection, FREE_CONTEXT_SCROLL_ACTION_NAME, (TransportRequest)new ScrollFreeContextRequest(contextId), TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<SearchFreeContextResponse>(listener, SearchFreeContextResponse::new));
    }

    public void sendCanMatch(Transport.Connection connection, ShardSearchTransportRequest request, SearchTask task, ActionListener<SearchService.CanMatchResponse> listener) {
        if (!connection.getNode().getVersion().onOrAfter(Version.V_5_6_0)) {
            throw new IllegalArgumentException("can_match is not supported on pre 5.6 nodes");
        }
        this.transportService.sendChildRequest(connection, QUERY_CAN_MATCH_NAME, (TransportRequest)request, (Task)task, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<SearchService.CanMatchResponse>(listener, SearchService.CanMatchResponse::new));
    }

    public void sendClearAllScrollContexts(Transport.Connection connection, ActionListener<TransportResponse> listener) {
        this.transportService.sendRequest(connection, CLEAR_SCROLL_CONTEXTS_ACTION_NAME, (TransportRequest)TransportRequest.Empty.INSTANCE, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<TransportResponse.Empty>(listener, in -> TransportResponse.Empty.INSTANCE));
    }

    public void sendExecuteDfs(Transport.Connection connection, ShardSearchTransportRequest request, SearchTask task, SearchActionListener<DfsSearchResult> listener) {
        this.transportService.sendChildRequest(connection, DFS_ACTION_NAME, request, task, new ConnectionCountingHandler<DfsSearchResult>(listener, DfsSearchResult::new, this.clientConnections, connection.getNode().getId()));
    }

    public void sendExecuteQuery(Transport.Connection connection, ShardSearchTransportRequest request, SearchTask task, SearchActionListener<SearchPhaseResult> listener) {
        boolean fetchDocuments = request.numberOfShards() == 1;
        Writeable.Reader<SearchPhaseResult> reader = fetchDocuments ? QueryFetchSearchResult::new : QuerySearchResult::new;
        ActionListener handler = this.responseWrapper.apply(connection, listener);
        this.transportService.sendChildRequest(connection, QUERY_ACTION_NAME, request, task, new ConnectionCountingHandler<SearchPhaseResult>(handler, reader, this.clientConnections, connection.getNode().getId()));
    }

    public void sendExecuteQuery(Transport.Connection connection, QuerySearchRequest request, SearchTask task, SearchActionListener<QuerySearchResult> listener) {
        this.transportService.sendChildRequest(connection, QUERY_ID_ACTION_NAME, request, task, new ConnectionCountingHandler<QuerySearchResult>(listener, QuerySearchResult::new, this.clientConnections, connection.getNode().getId()));
    }

    public void sendExecuteScrollQuery(Transport.Connection connection, InternalScrollSearchRequest request, SearchTask task, SearchActionListener<ScrollQuerySearchResult> listener) {
        this.transportService.sendChildRequest(connection, QUERY_SCROLL_ACTION_NAME, request, task, new ConnectionCountingHandler<ScrollQuerySearchResult>(listener, ScrollQuerySearchResult::new, this.clientConnections, connection.getNode().getId()));
    }

    public void sendExecuteScrollFetch(Transport.Connection connection, InternalScrollSearchRequest request, SearchTask task, SearchActionListener<ScrollQueryFetchSearchResult> listener) {
        this.transportService.sendChildRequest(connection, QUERY_FETCH_SCROLL_ACTION_NAME, request, task, new ConnectionCountingHandler<ScrollQueryFetchSearchResult>(listener, ScrollQueryFetchSearchResult::new, this.clientConnections, connection.getNode().getId()));
    }

    public void sendExecuteFetch(Transport.Connection connection, ShardFetchSearchRequest request, SearchTask task, SearchActionListener<FetchSearchResult> listener) {
        this.sendExecuteFetch(connection, FETCH_ID_ACTION_NAME, request, task, listener);
    }

    public void sendExecuteFetchScroll(Transport.Connection connection, ShardFetchRequest request, SearchTask task, SearchActionListener<FetchSearchResult> listener) {
        this.sendExecuteFetch(connection, FETCH_ID_SCROLL_ACTION_NAME, request, task, listener);
    }

    private void sendExecuteFetch(Transport.Connection connection, String action, ShardFetchRequest request, SearchTask task, SearchActionListener<FetchSearchResult> listener) {
        this.transportService.sendChildRequest(connection, action, request, task, new ConnectionCountingHandler<FetchSearchResult>(listener, FetchSearchResult::new, this.clientConnections, connection.getNode().getId()));
    }

    void sendExecuteMultiSearch(MultiSearchRequest request, SearchTask task, ActionListener<MultiSearchResponse> listener) {
        Transport.Connection connection = this.transportService.getConnection(this.transportService.getLocalNode());
        this.transportService.sendChildRequest(connection, "indices:data/read/msearch", request, task, new ConnectionCountingHandler<MultiSearchResponse>(listener, MultiSearchResponse::new, this.clientConnections, connection.getNode().getId()));
    }

    public RemoteClusterService getRemoteClusterService() {
        return this.transportService.getRemoteClusterService();
    }

    public Map<String, Long> getPendingSearchRequests() {
        return new HashMap<String, Long>(this.clientConnections);
    }

    public static void registerRequestHandler(TransportService transportService, final SearchService searchService) {
        transportService.registerRequestHandler(FREE_CONTEXT_SCROLL_ACTION_NAME, ScrollFreeContextRequest::new, "same", new TaskAwareTransportRequestHandler<ScrollFreeContextRequest>(){

            @Override
            public void messageReceived(ScrollFreeContextRequest request, TransportChannel channel, Task task) throws Exception {
                boolean freed = searchService.freeContext(request.id());
                channel.sendResponse(new SearchFreeContextResponse(freed));
            }
        });
        TransportActionProxy.registerProxyAction(transportService, FREE_CONTEXT_SCROLL_ACTION_NAME, SearchFreeContextResponse::new);
        transportService.registerRequestHandler(FREE_CONTEXT_ACTION_NAME, SearchFreeContextRequest::new, "same", new TaskAwareTransportRequestHandler<SearchFreeContextRequest>(){

            @Override
            public void messageReceived(SearchFreeContextRequest request, TransportChannel channel, Task task) throws Exception {
                boolean freed = searchService.freeContext(request.id());
                channel.sendResponse(new SearchFreeContextResponse(freed));
            }
        });
        TransportActionProxy.registerProxyAction(transportService, FREE_CONTEXT_ACTION_NAME, SearchFreeContextResponse::new);
        transportService.registerRequestHandler(CLEAR_SCROLL_CONTEXTS_ACTION_NAME, () -> TransportRequest.Empty.INSTANCE, "same", new TaskAwareTransportRequestHandler<TransportRequest.Empty>(){

            @Override
            public void messageReceived(TransportRequest.Empty request, TransportChannel channel, Task task) throws Exception {
                searchService.freeAllScrollContexts();
                channel.sendResponse(TransportResponse.Empty.INSTANCE);
            }
        });
        TransportActionProxy.registerProxyAction(transportService, CLEAR_SCROLL_CONTEXTS_ACTION_NAME, in -> TransportResponse.Empty.INSTANCE);
        transportService.registerRequestHandler(DFS_ACTION_NAME, ShardSearchTransportRequest::new, "same", new TaskAwareTransportRequestHandler<ShardSearchTransportRequest>(){

            @Override
            public void messageReceived(ShardSearchTransportRequest request, TransportChannel channel, Task task) {
                searchService.executeDfsPhase(request, (SearchTask)task, new ChannelActionListener(channel, SearchTransportService.DFS_ACTION_NAME, request));
            }
        });
        TransportActionProxy.registerProxyAction(transportService, DFS_ACTION_NAME, DfsSearchResult::new);
        transportService.registerRequestHandler(QUERY_ACTION_NAME, ShardSearchTransportRequest::new, "same", new TaskAwareTransportRequestHandler<ShardSearchTransportRequest>(){

            @Override
            public void messageReceived(ShardSearchTransportRequest request, TransportChannel channel, Task task) {
                searchService.executeQueryPhase(request, (SearchTask)task, new ChannelActionListener(channel, SearchTransportService.QUERY_ACTION_NAME, request));
            }
        });
        TransportActionProxy.registerProxyActionWithDynamicResponseType(transportService, QUERY_ACTION_NAME, request -> ((ShardSearchRequest)((Object)request)).numberOfShards() == 1 ? QueryFetchSearchResult::new : QuerySearchResult::new);
        transportService.registerRequestHandler(QUERY_ID_ACTION_NAME, QuerySearchRequest::new, "same", new TaskAwareTransportRequestHandler<QuerySearchRequest>(){

            @Override
            public void messageReceived(QuerySearchRequest request, TransportChannel channel, Task task) {
                searchService.executeQueryPhase(request, (SearchTask)task, new ChannelActionListener(channel, SearchTransportService.QUERY_ID_ACTION_NAME, request));
            }
        });
        TransportActionProxy.registerProxyAction(transportService, QUERY_ID_ACTION_NAME, QuerySearchResult::new);
        transportService.registerRequestHandler(QUERY_SCROLL_ACTION_NAME, InternalScrollSearchRequest::new, "same", new TaskAwareTransportRequestHandler<InternalScrollSearchRequest>(){

            @Override
            public void messageReceived(InternalScrollSearchRequest request, TransportChannel channel, Task task) {
                searchService.executeQueryPhase(request, (SearchTask)task, new ChannelActionListener(channel, SearchTransportService.QUERY_SCROLL_ACTION_NAME, request));
            }
        });
        TransportActionProxy.registerProxyAction(transportService, QUERY_SCROLL_ACTION_NAME, ScrollQuerySearchResult::new);
        transportService.registerRequestHandler(QUERY_FETCH_SCROLL_ACTION_NAME, InternalScrollSearchRequest::new, "same", new TaskAwareTransportRequestHandler<InternalScrollSearchRequest>(){

            @Override
            public void messageReceived(InternalScrollSearchRequest request, TransportChannel channel, Task task) {
                searchService.executeFetchPhase(request, (SearchTask)task, new ChannelActionListener(channel, SearchTransportService.QUERY_FETCH_SCROLL_ACTION_NAME, request));
            }
        });
        TransportActionProxy.registerProxyAction(transportService, QUERY_FETCH_SCROLL_ACTION_NAME, ScrollQueryFetchSearchResult::new);
        transportService.registerRequestHandler(FETCH_ID_SCROLL_ACTION_NAME, ShardFetchRequest::new, "same", new TaskAwareTransportRequestHandler<ShardFetchRequest>(){

            @Override
            public void messageReceived(ShardFetchRequest request, TransportChannel channel, Task task) {
                searchService.executeFetchPhase(request, (SearchTask)task, new ChannelActionListener(channel, SearchTransportService.FETCH_ID_SCROLL_ACTION_NAME, request));
            }
        });
        TransportActionProxy.registerProxyAction(transportService, FETCH_ID_SCROLL_ACTION_NAME, FetchSearchResult::new);
        transportService.registerRequestHandler(FETCH_ID_ACTION_NAME, ShardFetchSearchRequest::new, "same", true, true, new TaskAwareTransportRequestHandler<ShardFetchSearchRequest>(){

            @Override
            public void messageReceived(ShardFetchSearchRequest request, TransportChannel channel, Task task) {
                searchService.executeFetchPhase(request, (SearchTask)task, new ChannelActionListener(channel, SearchTransportService.FETCH_ID_ACTION_NAME, request));
            }
        });
        TransportActionProxy.registerProxyAction(transportService, FETCH_ID_ACTION_NAME, FetchSearchResult::new);
        transportService.registerRequestHandler(QUERY_CAN_MATCH_NAME, ShardSearchTransportRequest::new, "same", new TaskAwareTransportRequestHandler<ShardSearchTransportRequest>(){

            @Override
            public void messageReceived(ShardSearchTransportRequest request, TransportChannel channel, Task task) throws Exception {
                boolean canMatch = searchService.canMatch(request);
                channel.sendResponse(new SearchService.CanMatchResponse(canMatch));
            }
        });
        TransportActionProxy.registerProxyAction(transportService, QUERY_CAN_MATCH_NAME, SearchService.CanMatchResponse::new);
    }

    Transport.Connection getConnection(@Nullable String clusterAlias, DiscoveryNode node) {
        if (clusterAlias == null) {
            return this.transportService.getConnection(node);
        }
        return this.transportService.getRemoteClusterService().getConnection(node, clusterAlias);
    }

    final class ConnectionCountingHandler<Response extends TransportResponse>
    extends ActionListenerResponseHandler<Response> {
        private final Map<String, Long> clientConnections;
        private final String nodeId;

        ConnectionCountingHandler(ActionListener<? super Response> listener, Writeable.Reader<Response> responseReader, Map<String, Long> clientConnections, String nodeId) {
            super(listener, responseReader);
            this.clientConnections = clientConnections;
            this.nodeId = nodeId;
            clientConnections.compute(nodeId, (id, conns) -> conns == null ? 1L : conns + 1L);
        }

        @Override
        public void handleResponse(Response response) {
            super.handleResponse(response);
            assert (this.assertNodePresent());
            this.clientConnections.computeIfPresent(this.nodeId, (id, conns) -> conns == 1L ? null : Long.valueOf(conns - 1L));
        }

        @Override
        public void handleException(TransportException e) {
            super.handleException(e);
            assert (this.assertNodePresent());
            this.clientConnections.computeIfPresent(this.nodeId, (id, conns) -> conns == 1L ? null : Long.valueOf(conns - 1L));
        }

        private boolean assertNodePresent() {
            this.clientConnections.compute(this.nodeId, (id, conns) -> {
                assert (conns != null) : "number of connections for " + id + " is null, but should be an integer";
                assert (conns >= 1L) : "number of connections for " + id + " should be >= 1 but was " + conns;
                return conns;
            });
            return true;
        }
    }

    public static class SearchFreeContextResponse
    extends TransportResponse {
        private boolean freed;

        SearchFreeContextResponse() {
        }

        SearchFreeContextResponse(StreamInput in) throws IOException {
            this.freed = in.readBoolean();
        }

        SearchFreeContextResponse(boolean freed) {
            this.freed = freed;
        }

        public boolean isFreed() {
            return this.freed;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.freed = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.freed);
        }
    }

    static class SearchFreeContextRequest
    extends ScrollFreeContextRequest
    implements IndicesRequest {
        private OriginalIndices originalIndices;

        SearchFreeContextRequest() {
        }

        SearchFreeContextRequest(OriginalIndices originalIndices, long id) {
            super(id);
            this.originalIndices = originalIndices;
        }

        @Override
        public String[] indices() {
            if (this.originalIndices == null) {
                return null;
            }
            return this.originalIndices.indices();
        }

        @Override
        public IndicesOptions indicesOptions() {
            if (this.originalIndices == null) {
                return null;
            }
            return this.originalIndices.indicesOptions();
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.originalIndices = OriginalIndices.readOriginalIndices(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            OriginalIndices.writeOriginalIndices(this.originalIndices, out);
        }
    }

    static class ScrollFreeContextRequest
    extends TransportRequest {
        private long id;

        ScrollFreeContextRequest() {
        }

        ScrollFreeContextRequest(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.id = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeLong(this.id);
        }
    }
}

