/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.search;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.search.ParsedScrollId;
import conductor.org.elasticsearch.action.search.SearchPhaseController;
import conductor.org.elasticsearch.action.search.SearchResponse;
import conductor.org.elasticsearch.action.search.SearchScrollAsyncAction;
import conductor.org.elasticsearch.action.search.SearchScrollQueryAndFetchAsyncAction;
import conductor.org.elasticsearch.action.search.SearchScrollQueryThenFetchAsyncAction;
import conductor.org.elasticsearch.action.search.SearchScrollRequest;
import conductor.org.elasticsearch.action.search.SearchTask;
import conductor.org.elasticsearch.action.search.SearchTransportService;
import conductor.org.elasticsearch.action.search.TransportSearchHelper;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.HandledTransportAction;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.tasks.Task;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;

public class TransportSearchScrollAction
extends HandledTransportAction<SearchScrollRequest, SearchResponse> {
    private final ClusterService clusterService;
    private final SearchTransportService searchTransportService;
    private final SearchPhaseController searchPhaseController;

    @Inject
    public TransportSearchScrollAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SearchTransportService searchTransportService, SearchPhaseController searchPhaseController) {
        super(settings, "indices:data/read/scroll", threadPool, transportService, actionFilters, indexNameExpressionResolver, SearchScrollRequest::new);
        this.clusterService = clusterService;
        this.searchTransportService = searchTransportService;
        this.searchPhaseController = searchPhaseController;
    }

    @Override
    protected final void doExecute(SearchScrollRequest request, ActionListener<SearchResponse> listener) {
        throw new UnsupportedOperationException("the task parameter is required");
    }

    @Override
    protected void doExecute(Task task, SearchScrollRequest request, ActionListener<SearchResponse> listener) {
        try {
            SearchScrollAsyncAction action;
            ParsedScrollId scrollId = TransportSearchHelper.parseScrollId(request.scrollId());
            switch (scrollId.getType()) {
                case "queryThenFetch": {
                    action = new SearchScrollQueryThenFetchAsyncAction(this.logger, this.clusterService, this.searchTransportService, this.searchPhaseController, request, (SearchTask)task, scrollId, listener);
                    break;
                }
                case "queryAndFetch": {
                    action = new SearchScrollQueryAndFetchAsyncAction(this.logger, this.clusterService, this.searchTransportService, this.searchPhaseController, request, (SearchTask)task, scrollId, listener);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Scroll id type [" + scrollId.getType() + "] unrecognized");
                }
            }
            action.run();
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

