/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.support.nodes;

import conductor.org.elasticsearch.action.ActionResponse;
import conductor.org.elasticsearch.action.FailedNodeException;
import conductor.org.elasticsearch.action.support.nodes.BaseNodeResponse;
import conductor.org.elasticsearch.cluster.ClusterName;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class BaseNodesResponse<TNodeResponse extends BaseNodeResponse>
extends ActionResponse {
    private ClusterName clusterName;
    private List<FailedNodeException> failures;
    private List<TNodeResponse> nodes;
    private Map<String, TNodeResponse> nodesMap;

    protected BaseNodesResponse() {
    }

    protected BaseNodesResponse(ClusterName clusterName, List<TNodeResponse> nodes, List<FailedNodeException> failures) {
        this.clusterName = Objects.requireNonNull(clusterName);
        this.failures = Objects.requireNonNull(failures);
        this.nodes = Objects.requireNonNull(nodes);
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public List<FailedNodeException> failures() {
        return this.failures;
    }

    public boolean hasFailures() {
        return !this.failures.isEmpty();
    }

    public List<TNodeResponse> getNodes() {
        return this.nodes;
    }

    public Map<String, TNodeResponse> getNodesMap() {
        if (this.nodesMap == null) {
            this.nodesMap = new HashMap<String, TNodeResponse>();
            for (BaseNodeResponse nodeResponse : this.nodes) {
                this.nodesMap.put(nodeResponse.getNode().getId(), nodeResponse);
            }
        }
        return this.nodesMap;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.clusterName = new ClusterName(in);
        this.nodes = this.readNodesFrom(in);
        this.failures = in.readList(FailedNodeException::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.clusterName.writeTo(out);
        this.writeNodesTo(out, this.nodes);
        out.writeList(this.failures);
    }

    protected abstract List<TNodeResponse> readNodesFrom(StreamInput var1) throws IOException;

    protected abstract void writeNodesTo(StreamOutput var1, List<TNodeResponse> var2) throws IOException;
}

