/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client;

import conductor.org.apache.http.entity.ContentType;
import conductor.org.apache.http.nio.entity.NByteArrayEntity;
import conductor.org.elasticsearch.client.Request;
import conductor.org.elasticsearch.client.RequestConverters;
import conductor.org.elasticsearch.client.watcher.AckWatchRequest;
import conductor.org.elasticsearch.client.watcher.ActivateWatchRequest;
import conductor.org.elasticsearch.client.watcher.DeactivateWatchRequest;
import conductor.org.elasticsearch.client.watcher.DeleteWatchRequest;
import conductor.org.elasticsearch.client.watcher.ExecuteWatchRequest;
import conductor.org.elasticsearch.client.watcher.GetWatchRequest;
import conductor.org.elasticsearch.client.watcher.PutWatchRequest;
import conductor.org.elasticsearch.client.watcher.StartWatchServiceRequest;
import conductor.org.elasticsearch.client.watcher.StopWatchServiceRequest;
import conductor.org.elasticsearch.client.watcher.WatcherStatsRequest;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import java.io.IOException;

final class WatcherRequestConverters {
    private WatcherRequestConverters() {
    }

    static Request startWatchService(StartWatchServiceRequest startWatchServiceRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("watcher").addPathPartAsIs("_start").build();
        return new Request("POST", endpoint);
    }

    static Request stopWatchService(StopWatchServiceRequest stopWatchServiceRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("watcher").addPathPartAsIs("_stop").build();
        return new Request("POST", endpoint);
    }

    static Request putWatch(PutWatchRequest putWatchRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack", "watcher", "watch").addPathPart(putWatchRequest.getId()).build();
        Request request = new Request("PUT", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request).withVersion(putWatchRequest.getVersion()).withIfSeqNo(putWatchRequest.ifSeqNo()).withIfPrimaryTerm(putWatchRequest.ifPrimaryTerm());
        if (!putWatchRequest.isActive()) {
            params.putParam("active", "false");
        }
        ContentType contentType = RequestConverters.createContentType(putWatchRequest.xContentType());
        BytesReference source = putWatchRequest.getSource();
        request.setEntity(new NByteArrayEntity(source.toBytesRef().bytes, 0, source.length(), contentType));
        return request;
    }

    static Request getWatch(GetWatchRequest getWatchRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack", "watcher", "watch").addPathPart(getWatchRequest.getId()).build();
        return new Request("GET", endpoint);
    }

    static Request deactivateWatch(DeactivateWatchRequest deactivateWatchRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("watcher").addPathPartAsIs("watch").addPathPart(deactivateWatchRequest.getWatchId()).addPathPartAsIs("_deactivate").build();
        return new Request("PUT", endpoint);
    }

    static Request deleteWatch(DeleteWatchRequest deleteWatchRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack", "watcher", "watch").addPathPart(deleteWatchRequest.getId()).build();
        Request request = new Request("DELETE", endpoint);
        return request;
    }

    static Request executeWatch(ExecuteWatchRequest executeWatchRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack", "watcher", "watch").addPathPart(executeWatchRequest.getId()).addPathPartAsIs("_execute").build();
        Request request = new Request("POST", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        if (executeWatchRequest.isDebug()) {
            params.putParam("debug", "true");
        }
        if (executeWatchRequest.ignoreCondition()) {
            params.putParam("ignore_condition", "true");
        }
        if (executeWatchRequest.recordExecution()) {
            params.putParam("record_execution", "true");
        }
        request.setEntity(RequestConverters.createEntity(executeWatchRequest, XContentType.JSON));
        return request;
    }

    public static Request ackWatch(AckWatchRequest ackWatchRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack", "watcher", "watch").addPathPart(ackWatchRequest.getWatchId()).addPathPartAsIs("_ack").addCommaSeparatedPathParts(ackWatchRequest.getActionIds()).build();
        Request request = new Request("PUT", endpoint);
        return request;
    }

    static Request activateWatch(ActivateWatchRequest activateWatchRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack", "watcher", "watch").addPathPart(activateWatchRequest.getWatchId()).addPathPartAsIs("_activate").build();
        Request request = new Request("PUT", endpoint);
        return request;
    }

    static Request watcherStats(WatcherStatsRequest watcherStatsRequest) {
        RequestConverters.EndpointBuilder builder = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack", "watcher", "stats");
        String endpoint = builder.build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        StringBuilder metric = new StringBuilder();
        if (watcherStatsRequest.includeCurrentWatches()) {
            metric.append("current_watches");
        }
        if (watcherStatsRequest.includeQueuedWatches()) {
            if (metric.length() > 0) {
                metric.append(",");
            }
            metric.append("queued_watches");
        }
        if (metric.length() > 0) {
            parameters.putParam("metric", metric.toString());
        }
        return request;
    }
}

