/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.indices;

import conductor.org.elasticsearch.cluster.metadata.AliasMetaData;
import conductor.org.elasticsearch.cluster.metadata.MappingMetaData;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.collect.ImmutableOpenMap;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class IndexTemplateMetaData {
    private static final ConstructingObjectParser<IndexTemplateMetaData, String> PARSER = new ConstructingObjectParser<IndexTemplateMetaData, String>("IndexTemplateMetaData", true, (a, name) -> {
        List alias = (List)a[5];
        ImmutableOpenMap<String, AliasMetaData> aliasMap = new ImmutableOpenMap.Builder<String, AliasMetaData>().putAll(alias.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).build();
        return new IndexTemplateMetaData((String)name, (Integer)a[0], (Integer)a[1], (List)a[2], (Settings)a[3], (MappingMetaData)a[4], aliasMap);
    });
    private final String name;
    private final int order;
    @Nullable
    private final Integer version;
    private final List<String> patterns;
    private final Settings settings;
    private final MappingMetaData mappings;
    private final ImmutableOpenMap<String, AliasMetaData> aliases;

    public IndexTemplateMetaData(String name, int order, Integer version, List<String> patterns, Settings settings, MappingMetaData mappings, ImmutableOpenMap<String, AliasMetaData> aliases) {
        if (patterns == null || patterns.isEmpty()) {
            throw new IllegalArgumentException("Index patterns must not be null or empty; got " + patterns);
        }
        this.name = name;
        this.order = order;
        this.version = version;
        this.patterns = patterns;
        this.settings = settings;
        this.mappings = mappings;
        this.aliases = aliases;
    }

    public String name() {
        return this.name;
    }

    public int order() {
        return this.order;
    }

    @Nullable
    public Integer version() {
        return this.version;
    }

    public List<String> patterns() {
        return this.patterns;
    }

    public Settings settings() {
        return this.settings;
    }

    public MappingMetaData mappings() {
        return this.mappings;
    }

    public ImmutableOpenMap<String, AliasMetaData> aliases() {
        return this.aliases;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexTemplateMetaData that = (IndexTemplateMetaData)o;
        return this.order == that.order && Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version) && Objects.equals(this.patterns, that.patterns) && Objects.equals(this.settings, that.settings) && Objects.equals(this.mappings, that.mappings) && Objects.equals(this.aliases, that.aliases);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.order, this.version, this.patterns, this.settings, this.mappings, this.aliases);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("order", new String[0]));
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("version", new String[0]));
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), new ParseField("index_patterns", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            Settings.Builder templateSettingsBuilder = Settings.builder();
            templateSettingsBuilder.put(Settings.fromXContent(p));
            templateSettingsBuilder.normalizePrefix("index.");
            return templateSettingsBuilder.build();
        }, new ParseField("settings", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            Map<String, Object> mapping = p.map();
            if (mapping.isEmpty()) {
                return null;
            }
            return new MappingMetaData("_doc", mapping);
        }, new ParseField("mappings", new String[0]));
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, name) -> new AbstractMap.SimpleEntry<String, AliasMetaData>(name, AliasMetaData.Builder.fromXContent(p)), new ParseField("aliases", new String[0]));
    }

    public static class Builder {
        private String name;
        private int order;
        private Integer version;
        private List<String> indexPatterns;
        private Settings settings = Settings.Builder.EMPTY_SETTINGS;
        private MappingMetaData mappings;
        private final ImmutableOpenMap.Builder<String, AliasMetaData> aliases;

        public Builder(String name) {
            this.name = name;
            this.mappings = null;
            this.aliases = ImmutableOpenMap.builder();
        }

        public Builder(IndexTemplateMetaData indexTemplateMetaData) {
            this.name = indexTemplateMetaData.name();
            this.order(indexTemplateMetaData.order());
            this.version(indexTemplateMetaData.version());
            this.patterns(indexTemplateMetaData.patterns());
            this.settings(indexTemplateMetaData.settings());
            this.mappings = indexTemplateMetaData.mappings();
            this.aliases = ImmutableOpenMap.builder(indexTemplateMetaData.aliases());
        }

        public Builder order(int order) {
            this.order = order;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder patterns(List<String> indexPatterns) {
            this.indexPatterns = indexPatterns;
            return this;
        }

        public Builder settings(Settings.Builder settings) {
            this.settings = settings.build();
            return this;
        }

        public Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public Builder mapping(MappingMetaData mappings) {
            this.mappings = mappings;
            return this;
        }

        public Builder putAlias(AliasMetaData aliasMetaData) {
            this.aliases.put(aliasMetaData.alias(), aliasMetaData);
            return this;
        }

        public Builder putAlias(AliasMetaData.Builder aliasMetaData) {
            this.aliases.put(aliasMetaData.alias(), aliasMetaData.build());
            return this;
        }

        public IndexTemplateMetaData build() {
            return new IndexTemplateMetaData(this.name, this.order, this.version, this.indexPatterns, this.settings, this.mappings, this.aliases.build());
        }

        public static IndexTemplateMetaData fromXContent(XContentParser parser, String templateName) throws IOException {
            return (IndexTemplateMetaData)PARSER.parse(parser, templateName);
        }
    }
}

