/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.security;

import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import java.io.IOException;
import java.util.Objects;

public final class CreateTokenResponse {
    private final String accessToken;
    private final String type;
    private final TimeValue expiresIn;
    private final String scope;
    private final String refreshToken;
    private static final ConstructingObjectParser<CreateTokenResponse, Void> PARSER = new ConstructingObjectParser("create_token_response", true, args -> new CreateTokenResponse((String)args[0], (String)args[1], TimeValue.timeValueSeconds((Long)args[2]), (String)args[3], (String)args[4]));

    public CreateTokenResponse(String accessToken, String type, TimeValue expiresIn, String scope, String refreshToken) {
        this.accessToken = accessToken;
        this.type = type;
        this.expiresIn = expiresIn;
        this.scope = scope;
        this.refreshToken = refreshToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getType() {
        return this.type;
    }

    public TimeValue getExpiresIn() {
        return this.expiresIn;
    }

    public String getScope() {
        return this.scope;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTokenResponse that = (CreateTokenResponse)o;
        return Objects.equals(this.accessToken, that.accessToken) && Objects.equals(this.type, that.type) && Objects.equals(this.expiresIn, that.expiresIn) && Objects.equals(this.scope, that.scope) && Objects.equals(this.refreshToken, that.refreshToken);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.type, this.expiresIn, this.scope, this.refreshToken);
    }

    public static CreateTokenResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("access_token", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("type", new String[0]));
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("expires_in", new String[0]));
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("scope", new String[0]));
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("refresh_token", new String[0]));
    }
}

