/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.security;

import conductor.org.elasticsearch.client.Validatable;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import java.io.IOException;

public final class InvalidateApiKeyRequest
implements Validatable,
ToXContentObject {
    private final String realmName;
    private final String userName;
    private final String id;
    private final String name;

    InvalidateApiKeyRequest(@Nullable String realmName, @Nullable String userName, @Nullable String apiKeyId, @Nullable String apiKeyName) {
        if (!(Strings.hasText(realmName) || Strings.hasText(userName) || Strings.hasText(apiKeyId) || Strings.hasText(apiKeyName))) {
            this.throwValidationError("One of [api key id, api key name, username, realm name] must be specified");
        }
        if ((Strings.hasText(apiKeyId) || Strings.hasText(apiKeyName)) && (Strings.hasText(realmName) || Strings.hasText(userName))) {
            this.throwValidationError("username or realm name must not be specified when the api key id or api key name is specified");
        }
        if (Strings.hasText(apiKeyId) && Strings.hasText(apiKeyName)) {
            this.throwValidationError("only one of [api key id, api key name] can be specified");
        }
        this.realmName = realmName;
        this.userName = userName;
        this.id = apiKeyId;
        this.name = apiKeyName;
    }

    private void throwValidationError(String message) {
        throw new IllegalArgumentException(message);
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static InvalidateApiKeyRequest usingRealmName(String realmName) {
        return new InvalidateApiKeyRequest(realmName, null, null, null);
    }

    public static InvalidateApiKeyRequest usingUserName(String userName) {
        return new InvalidateApiKeyRequest(null, userName, null, null);
    }

    public static InvalidateApiKeyRequest usingRealmAndUserName(String realmName, String userName) {
        return new InvalidateApiKeyRequest(realmName, userName, null, null);
    }

    public static InvalidateApiKeyRequest usingApiKeyId(String apiKeyId) {
        return new InvalidateApiKeyRequest(null, null, apiKeyId, null);
    }

    public static InvalidateApiKeyRequest usingApiKeyName(String apiKeyName) {
        return new InvalidateApiKeyRequest(null, null, null, apiKeyName);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.realmName != null) {
            builder.field("realm_name", this.realmName);
        }
        if (this.userName != null) {
            builder.field("username", this.userName);
        }
        if (this.id != null) {
            builder.field("id", this.id);
        }
        if (this.name != null) {
            builder.field("name", this.name);
        }
        return builder.endObject();
    }
}

