/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.security.support;

import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;

public final class ApiKey {
    private final String name;
    private final String id;
    private final Instant creation;
    private final Instant expiration;
    private final boolean invalidated;
    private final String username;
    private final String realm;
    static ConstructingObjectParser<ApiKey, Void> PARSER = new ConstructingObjectParser("api_key", args -> new ApiKey((String)args[0], (String)args[1], Instant.ofEpochMilli((Long)args[2]), args[3] == null ? null : Instant.ofEpochMilli((Long)args[3]), (Boolean)args[4], (String)args[5], (String)args[6]));

    public ApiKey(String name, String id, Instant creation, Instant expiration, boolean invalidated, String username, String realm) {
        this.name = name;
        this.id = id;
        this.creation = Instant.ofEpochMilli(creation.toEpochMilli());
        this.expiration = expiration != null ? Instant.ofEpochMilli(expiration.toEpochMilli()) : null;
        this.invalidated = invalidated;
        this.username = username;
        this.realm = realm;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Instant getCreation() {
        return this.creation;
    }

    public Instant getExpiration() {
        return this.expiration;
    }

    public boolean isInvalidated() {
        return this.invalidated;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRealm() {
        return this.realm;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.id, this.creation, this.expiration, this.invalidated, this.username, this.realm);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiKey other = (ApiKey)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.id, other.id) && Objects.equals(this.creation, other.creation) && Objects.equals(this.expiration, other.expiration) && Objects.equals(this.invalidated, other.invalidated) && Objects.equals(this.username, other.username) && Objects.equals(this.realm, other.realm);
    }

    public static ApiKey fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public String toString() {
        return "ApiKey [name=" + this.name + ", id=" + this.id + ", creation=" + this.creation + ", expiration=" + this.expiration + ", invalidated=" + this.invalidated + ", username=" + this.username + ", realm=" + this.realm + "]";
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("id", new String[0]));
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("creation", new String[0]));
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), new ParseField("expiration", new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("invalidated", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("username", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("realm", new String[0]));
    }
}

