/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.watcher;

import conductor.org.elasticsearch.ElasticsearchParseException;
import conductor.org.elasticsearch.common.time.DateFormatter;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.index.mapper.DateFieldMapper;
import conductor.org.joda.time.DateTime;
import conductor.org.joda.time.DateTimeZone;
import java.io.IOException;

public final class WatchStatusDateParser {
    private static final DateFormatter FORMATTER = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER;

    private WatchStatusDateParser() {
    }

    public static DateTime parseDate(String fieldName, XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_NUMBER) {
            return new DateTime(parser.longValue(), DateTimeZone.UTC);
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            DateTime dateTime = WatchStatusDateParser.parseDate(parser.text());
            return dateTime.toDateTime(DateTimeZone.UTC);
        }
        if (token == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        throw new ElasticsearchParseException("could not parse date/time. expected date field [{}] to be either a number or a string but found [{}] instead", new Object[]{fieldName, token});
    }

    public static DateTime parseDate(String text) {
        return FORMATTER.parseJoda(text);
    }
}

