/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.cluster.metadata;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.indices.delete.DeleteIndexClusterStateUpdateRequest;
import conductor.org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.RestoreInProgress;
import conductor.org.elasticsearch.cluster.ack.AckedRequest;
import conductor.org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import conductor.org.elasticsearch.cluster.block.ClusterBlocks;
import conductor.org.elasticsearch.cluster.metadata.IndexGraveyard;
import conductor.org.elasticsearch.cluster.metadata.IndexMetaData;
import conductor.org.elasticsearch.cluster.metadata.MetaData;
import conductor.org.elasticsearch.cluster.routing.RoutingTable;
import conductor.org.elasticsearch.cluster.routing.allocation.AllocationService;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.Priority;
import conductor.org.elasticsearch.common.collect.ImmutableOpenMap;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.util.set.Sets;
import conductor.org.elasticsearch.index.Index;
import conductor.org.elasticsearch.snapshots.RestoreService;
import conductor.org.elasticsearch.snapshots.SnapshotsService;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public class MetaDataDeleteIndexService {
    private static final Logger logger = LogManager.getLogger(MetaDataDeleteIndexService.class);
    private final Settings settings;
    private final ClusterService clusterService;
    private final AllocationService allocationService;

    @Inject
    public MetaDataDeleteIndexService(Settings settings, ClusterService clusterService, AllocationService allocationService) {
        this.settings = settings;
        this.clusterService = clusterService;
        this.allocationService = allocationService;
    }

    public void deleteIndices(final DeleteIndexClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        if (request.indices() == null || request.indices().length == 0) {
            throw new IllegalArgumentException("Index name is required");
        }
        this.clusterService.submitStateUpdateTask("delete-index " + Arrays.toString(request.indices()), new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, listener){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                return MetaDataDeleteIndexService.this.deleteIndices(currentState, Sets.newHashSet(request.indices()));
            }
        });
    }

    public ClusterState deleteIndices(ClusterState currentState, Set<Index> indices) {
        RestoreInProgress updatedRestoreInProgress;
        MetaData meta = currentState.metaData();
        Set<IndexMetaData> metaDatas = indices.stream().map(i -> meta.getIndexSafe((Index)i)).collect(Collectors.toSet());
        SnapshotsService.checkIndexDeletion(currentState, metaDatas);
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
        MetaData.Builder metaDataBuilder = MetaData.builder(meta);
        ClusterBlocks.Builder clusterBlocksBuilder = ClusterBlocks.builder().blocks(currentState.blocks());
        IndexGraveyard.Builder graveyardBuilder = IndexGraveyard.builder(metaDataBuilder.indexGraveyard());
        int previousGraveyardSize = graveyardBuilder.tombstones().size();
        for (Index index : indices) {
            String indexName = index.getName();
            logger.info("{} deleting index", (Object)index);
            routingTableBuilder.remove(indexName);
            clusterBlocksBuilder.removeIndexBlocks(indexName);
            metaDataBuilder.remove(indexName);
        }
        IndexGraveyard currentGraveyard = graveyardBuilder.addTombstones(indices).build(this.settings);
        metaDataBuilder.indexGraveyard(currentGraveyard);
        logger.trace("{} tombstones purged from the cluster state. Previous tombstone size: {}. Current tombstone size: {}.", (Object)graveyardBuilder.getNumPurged(), (Object)previousGraveyardSize, (Object)currentGraveyard.getTombstones().size());
        MetaData newMetaData = metaDataBuilder.build();
        ClusterBlocks blocks = clusterBlocksBuilder.build();
        ImmutableOpenMap<String, ClusterState.Custom> customs = currentState.getCustoms();
        RestoreInProgress restoreInProgress = (RestoreInProgress)currentState.custom("restore");
        if (restoreInProgress != null && (updatedRestoreInProgress = RestoreService.updateRestoreStateWithDeletedIndices(restoreInProgress, indices)) != restoreInProgress) {
            ImmutableOpenMap.Builder<String, ClusterState.Custom> builder = ImmutableOpenMap.builder(customs);
            builder.put("restore", updatedRestoreInProgress);
            customs = builder.build();
        }
        return this.allocationService.reroute(ClusterState.builder(currentState).routingTable(routingTableBuilder.build()).metaData(newMetaData).blocks(blocks).customs(customs).build(), "deleted indices [" + indices + "]");
    }
}

