/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.bytes;

import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.BytesRefBuilder;
import conductor.org.apache.lucene.util.BytesRefIterator;
import conductor.org.apache.lucene.util.FutureObjects;
import conductor.org.apache.lucene.util.RamUsageEstimator;
import conductor.org.elasticsearch.common.bytes.BytesArray;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public final class CompositeBytesReference
extends BytesReference {
    private final BytesReference[] references;
    private final int[] offsets;
    private final int length;
    private final long ramBytesUsed;

    public CompositeBytesReference(BytesReference ... references) {
        this.references = Objects.requireNonNull(references, "references must not be null");
        this.offsets = new int[references.length];
        long ramBytesUsed = 0L;
        int offset = 0;
        for (int i = 0; i < references.length; ++i) {
            BytesReference reference = references[i];
            if (reference == null) {
                throw new IllegalArgumentException("references must not be null");
            }
            this.offsets[i] = offset;
            offset += reference.length();
            ramBytesUsed += reference.ramBytesUsed();
        }
        this.ramBytesUsed = ramBytesUsed + (long)(4 * this.offsets.length + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER) + (long)(references.length * RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER) + 4L + 8L;
        this.length = offset;
    }

    @Override
    public byte get(int index) {
        int i = this.getOffsetIndex(index);
        return this.references[i].get(index - this.offsets[i]);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public BytesReference slice(int from, int length) {
        FutureObjects.checkFromIndexSize(from, length, this.length);
        if (length == 0) {
            return BytesArray.EMPTY;
        }
        int to = from + length;
        int limit = this.getOffsetIndex(to - 1);
        int start = this.getOffsetIndex(from);
        BytesReference[] inSlice = new BytesReference[1 + (limit - start)];
        int j = start;
        for (int i = 0; i < inSlice.length; ++i) {
            inSlice[i] = this.references[j++];
        }
        int inSliceOffset = from - this.offsets[start];
        if (inSlice.length == 1) {
            return inSlice[0].slice(inSliceOffset, length);
        }
        inSlice[0] = inSlice[0].slice(inSliceOffset, inSlice[0].length() - inSliceOffset);
        inSlice[inSlice.length - 1] = inSlice[inSlice.length - 1].slice(0, to - this.offsets[limit]);
        return new CompositeBytesReference(inSlice);
    }

    private int getOffsetIndex(int offset) {
        int i = Arrays.binarySearch(this.offsets, offset);
        return i < 0 ? -(i + 1) - 1 : i;
    }

    @Override
    public BytesRef toBytesRef() {
        BytesRefBuilder builder = new BytesRefBuilder();
        builder.grow(this.length());
        BytesRefIterator iterator = this.iterator();
        try {
            BytesRef spare;
            while ((spare = iterator.next()) != null) {
                builder.append(spare);
            }
        }
        catch (IOException ex) {
            throw new AssertionError("won't happen", ex);
        }
        return builder.toBytesRef();
    }

    @Override
    public BytesRefIterator iterator() {
        if (this.references.length > 0) {
            return new BytesRefIterator(){
                int index = 0;
                private BytesRefIterator current = CompositeBytesReference.access$000(CompositeBytesReference.this)[this.index++].iterator();

                @Override
                public BytesRef next() throws IOException {
                    BytesRef next = this.current.next();
                    if (next == null) {
                        while (this.index < CompositeBytesReference.this.references.length) {
                            this.current = CompositeBytesReference.this.references[this.index++].iterator();
                            next = this.current.next();
                            if (next == null) continue;
                            break;
                        }
                    }
                    return next;
                }
            };
        }
        return () -> null;
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }
}

