/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.geo;

import conductor.org.apache.lucene.document.LatLonShape;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import java.io.IOException;
import java.util.Locale;

public enum ShapeRelation implements Writeable
{
    INTERSECTS("intersects"),
    DISJOINT("disjoint"),
    WITHIN("within"),
    CONTAINS("contains");

    private final String relationName;

    private ShapeRelation(String relationName) {
        this.relationName = relationName;
    }

    public static ShapeRelation readFromStream(StreamInput in) throws IOException {
        return in.readEnum(ShapeRelation.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this);
    }

    public static ShapeRelation getRelationByName(String name) {
        name = name.toLowerCase(Locale.ENGLISH);
        for (ShapeRelation relation : ShapeRelation.values()) {
            if (!relation.relationName.equals(name)) continue;
            return relation;
        }
        return null;
    }

    public LatLonShape.QueryRelation getLuceneRelation() {
        switch (this) {
            case INTERSECTS: {
                return LatLonShape.QueryRelation.INTERSECTS;
            }
            case DISJOINT: {
                return LatLonShape.QueryRelation.DISJOINT;
            }
            case WITHIN: {
                return LatLonShape.QueryRelation.WITHIN;
            }
        }
        throw new IllegalArgumentException("ShapeRelation [" + this + "] not supported");
    }

    public String getRelationName() {
        return this.relationName;
    }
}

