/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.inject.spi;

import conductor.org.elasticsearch.common.inject.Binder;
import conductor.org.elasticsearch.common.inject.Scope;
import conductor.org.elasticsearch.common.inject.spi.Element;
import conductor.org.elasticsearch.common.inject.spi.ElementVisitor;
import java.lang.annotation.Annotation;
import java.util.Objects;

public final class ScopeBinding
implements Element {
    private final Object source;
    private final Class<? extends Annotation> annotationType;
    private final Scope scope;

    ScopeBinding(Object source, Class<? extends Annotation> annotationType, Scope scope) {
        this.source = Objects.requireNonNull(source, "source");
        this.annotationType = Objects.requireNonNull(annotationType, "annotationType");
        this.scope = Objects.requireNonNull(scope, "scope");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    public Scope getScope() {
        return this.scope;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).bindScope(this.annotationType, this.scope);
    }
}

