/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.inject.spi;

import conductor.org.elasticsearch.common.inject.Binder;
import conductor.org.elasticsearch.common.inject.ConfigurationException;
import conductor.org.elasticsearch.common.inject.spi.Element;
import conductor.org.elasticsearch.common.inject.spi.ElementVisitor;
import conductor.org.elasticsearch.common.inject.spi.InjectionPoint;
import java.util.Objects;
import java.util.Set;

public final class StaticInjectionRequest
implements Element {
    private final Object source;
    private final Class<?> type;

    StaticInjectionRequest(Object source, Class<?> type) {
        this.source = Objects.requireNonNull(source, "source");
        this.type = Objects.requireNonNull(type, "type");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Set<InjectionPoint> getInjectionPoints() throws ConfigurationException {
        return InjectionPoint.forStaticMethodsAndFields(this.type);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).requestStaticInjection(this.type);
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

