/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.io.stream;

import conductor.org.elasticsearch.common.bytes.ReleasablePagedBytesReference;
import conductor.org.elasticsearch.common.io.stream.BytesStreamOutput;
import conductor.org.elasticsearch.common.lease.Releasable;
import conductor.org.elasticsearch.common.lease.Releasables;
import conductor.org.elasticsearch.common.util.BigArrays;
import conductor.org.elasticsearch.common.util.ByteArray;

public class ReleasableBytesStreamOutput
extends BytesStreamOutput
implements Releasable {
    private Releasable releasable;

    public ReleasableBytesStreamOutput(BigArrays bigarrays) {
        this(16384, bigarrays);
    }

    public ReleasableBytesStreamOutput(int expectedSize, BigArrays bigArrays) {
        super(expectedSize, bigArrays);
        this.releasable = Releasables.releaseOnce(this.bytes);
    }

    @Override
    public ReleasablePagedBytesReference bytes() {
        return new ReleasablePagedBytesReference(this.bytes, this.count, this.releasable);
    }

    @Override
    public void close() {
        Releasables.close(this.releasable);
    }

    @Override
    void ensureCapacity(long offset) {
        ByteArray prevBytes = this.bytes;
        super.ensureCapacity(offset);
        if (prevBytes != this.bytes) {
            this.releasable = Releasables.releaseOnce(this.bytes);
        }
    }

    @Override
    public void reset() {
        ByteArray prevBytes = this.bytes;
        super.reset();
        if (prevBytes != this.bytes) {
            this.releasable = Releasables.releaseOnce(this.bytes);
        }
    }
}

