/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.ssl;

import conductor.org.elasticsearch.common.ssl.KeyStoreUtil;
import conductor.org.elasticsearch.common.ssl.SslConfigException;
import conductor.org.elasticsearch.common.ssl.SslKeyConfig;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.UnrecoverableKeyException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import javax.net.ssl.X509ExtendedKeyManager;

public class StoreKeyConfig
implements SslKeyConfig {
    private final Path path;
    private final char[] storePassword;
    private final String type;
    private final char[] keyPassword;
    private final String algorithm;

    StoreKeyConfig(Path path, char[] storePassword, String type, char[] keyPassword, String algorithm) {
        this.path = path;
        this.storePassword = storePassword;
        this.type = type;
        this.keyPassword = keyPassword;
        this.algorithm = algorithm;
    }

    @Override
    public Collection<Path> getDependentFiles() {
        return Collections.singleton(this.path);
    }

    @Override
    public X509ExtendedKeyManager createKeyManager() {
        try {
            KeyStore keyStore = KeyStoreUtil.readKeyStore(this.path, this.type, this.storePassword);
            this.checkKeyStore(keyStore);
            return KeyStoreUtil.createKeyManager(keyStore, this.keyPassword, this.algorithm);
        }
        catch (UnrecoverableKeyException e) {
            String message = "failed to load a KeyManager for keystore [" + this.path.toAbsolutePath() + "], this is usually caused by an incorrect key-password";
            if (this.keyPassword.length == 0) {
                message = message + " (no key-password was provided)";
            } else if (Arrays.equals(this.storePassword, this.keyPassword)) {
                message = message + " (we tried to access the key using the same password as the keystore)";
            }
            throw new SslConfigException(message, e);
        }
        catch (GeneralSecurityException e) {
            throw new SslConfigException("failed to load a KeyManager for keystore [" + this.path + "] of type [" + this.type + "]", e);
        }
    }

    private void checkKeyStore(KeyStore keyStore) throws KeyStoreException {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keyStore.isKeyEntry(alias)) continue;
            return;
        }
        String message = this.path != null ? "the keystore [" + this.path + "] does not contain a private key entry" : "the configured PKCS#11 token does not contain a private key entry";
        throw new SslConfigException(message);
    }
}

