/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.util;

import conductor.org.elasticsearch.common.lease.Releasable;
import conductor.org.elasticsearch.common.lease.Releasables;
import conductor.org.elasticsearch.common.util.BigArrays;
import conductor.org.elasticsearch.common.util.LongArray;

public final class BitArray
implements Releasable {
    private final BigArrays bigArrays;
    private LongArray bits;

    public BitArray(int initialSize, BigArrays bigArrays) {
        this.bigArrays = bigArrays;
        this.bits = bigArrays.newLongArray(initialSize, true);
    }

    public void set(int index) {
        this.fill(index, true);
    }

    public void clear(int index) {
        this.fill(index, false);
    }

    public boolean get(int index) {
        int wordNum = index >> 6;
        long bitmask = 1L << index;
        return (this.bits.get(wordNum) & bitmask) != 0L;
    }

    private void fill(int index, boolean bit) {
        int wordNum = index >> 6;
        this.bits = this.bigArrays.grow(this.bits, (long)(wordNum + 1));
        long bitmask = 1L << index;
        long value = bit ? this.bits.get(wordNum) | bitmask : this.bits.get(wordNum) & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
        this.bits.set(wordNum, value);
    }

    @Override
    public void close() {
        Releasables.close(this.bits);
    }
}

