/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.gateway;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.cluster.metadata.IndexMetaData;
import conductor.org.elasticsearch.cluster.metadata.MetaData;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.env.NodeEnvironment;
import conductor.org.elasticsearch.index.Index;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class MetaStateService {
    private static final Logger logger = LogManager.getLogger(MetaStateService.class);
    private final NodeEnvironment nodeEnv;
    private final NamedXContentRegistry namedXContentRegistry;

    public MetaStateService(NodeEnvironment nodeEnv, NamedXContentRegistry namedXContentRegistry) {
        this.nodeEnv = nodeEnv;
        this.namedXContentRegistry = namedXContentRegistry;
    }

    MetaData loadFullState() throws IOException {
        MetaData globalMetaData = this.loadGlobalState();
        MetaData.Builder metaDataBuilder = globalMetaData != null ? MetaData.builder(globalMetaData) : MetaData.builder();
        for (String indexFolderName : this.nodeEnv.availableIndexFolders()) {
            IndexMetaData indexMetaData = IndexMetaData.FORMAT.loadLatestState(logger, this.namedXContentRegistry, this.nodeEnv.resolveIndexFolder(indexFolderName));
            if (indexMetaData != null) {
                metaDataBuilder.put(indexMetaData, false);
                continue;
            }
            logger.debug("[{}] failed to find metadata for existing index location", (Object)indexFolderName);
        }
        return metaDataBuilder.build();
    }

    @Nullable
    public IndexMetaData loadIndexState(Index index) throws IOException {
        return IndexMetaData.FORMAT.loadLatestState(logger, this.namedXContentRegistry, this.nodeEnv.indexPaths(index));
    }

    List<IndexMetaData> loadIndicesStates(Predicate<String> excludeIndexPathIdsPredicate) throws IOException {
        ArrayList<IndexMetaData> indexMetaDataList = new ArrayList<IndexMetaData>();
        for (String indexFolderName : this.nodeEnv.availableIndexFolders(excludeIndexPathIdsPredicate)) {
            assert (!excludeIndexPathIdsPredicate.test(indexFolderName)) : "unexpected folder " + indexFolderName + " which should have been excluded";
            IndexMetaData indexMetaData = IndexMetaData.FORMAT.loadLatestState(logger, this.namedXContentRegistry, this.nodeEnv.resolveIndexFolder(indexFolderName));
            if (indexMetaData != null) {
                String indexPathId = indexMetaData.getIndex().getUUID();
                if (indexFolderName.equals(indexPathId)) {
                    indexMetaDataList.add(indexMetaData);
                    continue;
                }
                throw new IllegalStateException("[" + indexFolderName + "] invalid index folder name, rename to [" + indexPathId + "]");
            }
            logger.debug("[{}] failed to find metadata for existing index location", (Object)indexFolderName);
        }
        return indexMetaDataList;
    }

    MetaData loadGlobalState() throws IOException {
        return MetaData.FORMAT.loadLatestState(logger, this.namedXContentRegistry, this.nodeEnv.nodeDataPaths());
    }

    public void writeIndex(String reason, IndexMetaData indexMetaData) throws IOException {
        Index index = indexMetaData.getIndex();
        logger.trace("[{}] writing state, reason [{}]", (Object)index, (Object)reason);
        try {
            IndexMetaData.FORMAT.write(indexMetaData, this.nodeEnv.indexPaths(indexMetaData.getIndex()));
            logger.trace("[{}] state written", (Object)index);
        }
        catch (Exception ex) {
            logger.warn(() -> new ParameterizedMessage("[{}]: failed to write index state", (Object)index), (Throwable)ex);
            throw new IOException("failed to write state for [" + index + "]", ex);
        }
    }

    void writeGlobalState(String reason, MetaData metaData) throws IOException {
        logger.trace("[_global] writing state, reason [{}]", (Object)reason);
        try {
            MetaData.FORMAT.write(metaData, this.nodeEnv.nodeDataPaths());
            logger.trace("[_global] state written");
        }
        catch (Exception ex) {
            logger.warn("[_global]: failed to write global state", (Throwable)ex);
            throw new IOException("failed to write global state", ex);
        }
    }
}

