/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index;

import conductor.org.apache.lucene.search.similarities.Similarity;
import conductor.org.apache.lucene.store.MMapDirectory;
import conductor.org.apache.lucene.util.Constants;
import conductor.org.apache.lucene.util.SetOnce;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.client.Client;
import conductor.org.elasticsearch.common.TriFunction;
import conductor.org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import conductor.org.elasticsearch.common.settings.Setting;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.util.BigArrays;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.core.internal.io.IOUtils;
import conductor.org.elasticsearch.env.NodeEnvironment;
import conductor.org.elasticsearch.index.CompositeIndexEventListener;
import conductor.org.elasticsearch.index.Index;
import conductor.org.elasticsearch.index.IndexService;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.IndexingSlowLog;
import conductor.org.elasticsearch.index.SearchSlowLog;
import conductor.org.elasticsearch.index.analysis.AnalysisRegistry;
import conductor.org.elasticsearch.index.analysis.IndexAnalyzers;
import conductor.org.elasticsearch.index.cache.query.DisabledQueryCache;
import conductor.org.elasticsearch.index.cache.query.IndexQueryCache;
import conductor.org.elasticsearch.index.cache.query.QueryCache;
import conductor.org.elasticsearch.index.engine.EngineFactory;
import conductor.org.elasticsearch.index.mapper.MapperService;
import conductor.org.elasticsearch.index.shard.IndexEventListener;
import conductor.org.elasticsearch.index.shard.IndexSearcherWrapper;
import conductor.org.elasticsearch.index.shard.IndexingOperationListener;
import conductor.org.elasticsearch.index.shard.SearchOperationListener;
import conductor.org.elasticsearch.index.similarity.SimilarityService;
import conductor.org.elasticsearch.index.store.IndexStore;
import conductor.org.elasticsearch.indices.IndicesQueryCache;
import conductor.org.elasticsearch.indices.breaker.CircuitBreakerService;
import conductor.org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;
import conductor.org.elasticsearch.indices.mapper.MapperRegistry;
import conductor.org.elasticsearch.script.ScriptService;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public final class IndexModule {
    public static final Setting<Boolean> NODE_STORE_ALLOW_MMAPFS = Setting.boolSetting("node.store.allow_mmapfs", true, Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<Boolean> NODE_STORE_ALLOW_MMAP = Setting.boolSetting("node.store.allow_mmap", NODE_STORE_ALLOW_MMAPFS, Setting.Property.NodeScope);
    public static final Setting<String> INDEX_STORE_TYPE_SETTING = new Setting("index.store.type", "", Function.identity(), Setting.Property.IndexScope, Setting.Property.NodeScope);
    public static final Setting<List<String>> INDEX_STORE_PRE_LOAD_SETTING = Setting.listSetting("index.store.preload", Collections.emptyList(), Function.identity(), Setting.Property.IndexScope, Setting.Property.NodeScope);
    public static final String SIMILARITY_SETTINGS_PREFIX = "index.similarity";
    public static final Setting<Boolean> INDEX_QUERY_CACHE_ENABLED_SETTING = Setting.boolSetting("index.queries.cache.enabled", true, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_QUERY_CACHE_EVERYTHING_SETTING = Setting.boolSetting("index.queries.cache.everything", false, Setting.Property.IndexScope);
    private final IndexSettings indexSettings;
    private final AnalysisRegistry analysisRegistry;
    private final EngineFactory engineFactory;
    private SetOnce<IndexSearcherWrapperFactory> indexSearcherWrapper = new SetOnce();
    private final Set<IndexEventListener> indexEventListeners = new HashSet<IndexEventListener>();
    private final Map<String, TriFunction<Settings, Version, ScriptService, Similarity>> similarities = new HashMap<String, TriFunction<Settings, Version, ScriptService, Similarity>>();
    private final Map<String, Function<IndexSettings, IndexStore>> indexStoreFactories;
    private final SetOnce<BiFunction<IndexSettings, IndicesQueryCache, QueryCache>> forceQueryCacheProvider = new SetOnce();
    private final List<SearchOperationListener> searchOperationListeners = new ArrayList<SearchOperationListener>();
    private final List<IndexingOperationListener> indexOperationListeners = new ArrayList<IndexingOperationListener>();
    private final AtomicBoolean frozen = new AtomicBoolean(false);

    public IndexModule(IndexSettings indexSettings, AnalysisRegistry analysisRegistry, EngineFactory engineFactory, Map<String, Function<IndexSettings, IndexStore>> indexStoreFactories) {
        this.indexSettings = indexSettings;
        this.analysisRegistry = analysisRegistry;
        this.engineFactory = Objects.requireNonNull(engineFactory);
        this.searchOperationListeners.add(new SearchSlowLog(indexSettings));
        this.indexOperationListeners.add(new IndexingSlowLog(indexSettings));
        this.indexStoreFactories = Collections.unmodifiableMap(indexStoreFactories);
    }

    public <T> void addSettingsUpdateConsumer(Setting<T> setting, Consumer<T> consumer) {
        this.ensureNotFrozen();
        if (setting == null) {
            throw new IllegalArgumentException("setting must not be null");
        }
        this.indexSettings.getScopedSettings().addSettingsUpdateConsumer(setting, consumer);
    }

    public <T> void addSettingsUpdateConsumer(Setting<T> setting, Consumer<T> consumer, Consumer<T> validator) {
        this.ensureNotFrozen();
        if (setting == null) {
            throw new IllegalArgumentException("setting must not be null");
        }
        this.indexSettings.getScopedSettings().addSettingsUpdateConsumer(setting, consumer, validator);
    }

    public Settings getSettings() {
        return this.indexSettings.getSettings();
    }

    public Index getIndex() {
        return this.indexSettings.getIndex();
    }

    EngineFactory getEngineFactory() {
        return this.engineFactory;
    }

    public void addIndexEventListener(IndexEventListener listener) {
        this.ensureNotFrozen();
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.indexEventListeners.contains(listener)) {
            throw new IllegalArgumentException("listener already added");
        }
        this.indexEventListeners.add(listener);
    }

    public void addSearchOperationListener(SearchOperationListener listener) {
        this.ensureNotFrozen();
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.searchOperationListeners.contains(listener)) {
            throw new IllegalArgumentException("listener already added");
        }
        this.searchOperationListeners.add(listener);
    }

    public void addIndexOperationListener(IndexingOperationListener listener) {
        this.ensureNotFrozen();
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.indexOperationListeners.contains(listener)) {
            throw new IllegalArgumentException("listener already added");
        }
        this.indexOperationListeners.add(listener);
    }

    public void addSimilarity(String name, TriFunction<Settings, Version, ScriptService, Similarity> similarity) {
        this.ensureNotFrozen();
        if (this.similarities.containsKey(name) || SimilarityService.BUILT_IN.containsKey(name)) {
            throw new IllegalArgumentException("similarity for name: [" + name + " is already registered");
        }
        this.similarities.put(name, similarity);
    }

    public void setSearcherWrapper(IndexSearcherWrapperFactory indexSearcherWrapperFactory) {
        this.ensureNotFrozen();
        this.indexSearcherWrapper.set(indexSearcherWrapperFactory);
    }

    IndexEventListener freeze() {
        if (this.frozen.compareAndSet(false, true)) {
            return new CompositeIndexEventListener(this.indexSettings, this.indexEventListeners);
        }
        throw new IllegalStateException("already frozen");
    }

    public static boolean isBuiltinType(String storeType) {
        for (Type type : Type.values()) {
            if (!type.match(storeType)) continue;
            return true;
        }
        return false;
    }

    public static Type defaultStoreType(boolean allowMmap) {
        if (allowMmap && Constants.JRE_IS_64BIT && MMapDirectory.UNMAP_SUPPORTED) {
            return Type.MMAPFS;
        }
        if (Constants.WINDOWS) {
            return Type.SIMPLEFS;
        }
        return Type.NIOFS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexService newIndexService(NodeEnvironment environment, NamedXContentRegistry xContentRegistry, IndexService.ShardStoreDeleter shardStoreDeleter, CircuitBreakerService circuitBreakerService, BigArrays bigArrays, ThreadPool threadPool, ScriptService scriptService, Client client, IndicesQueryCache indicesQueryCache, MapperRegistry mapperRegistry, IndicesFieldDataCache indicesFieldDataCache, NamedWriteableRegistry namedWriteableRegistry) throws IOException {
        IndexService indexService;
        block3: {
            IndexEventListener eventListener = this.freeze();
            IndexSearcherWrapperFactory searcherWrapperFactory = this.indexSearcherWrapper.get() == null ? shard -> null : this.indexSearcherWrapper.get();
            eventListener.beforeIndexCreated(this.indexSettings.getIndex(), this.indexSettings.getSettings());
            IndexStore store = IndexModule.getIndexStore(this.indexSettings, this.indexStoreFactories);
            QueryCache queryCache = null;
            IndexAnalyzers indexAnalyzers = null;
            boolean success = false;
            try {
                BiFunction<IndexSettings, IndicesQueryCache, QueryCache> queryCacheProvider;
                queryCache = this.indexSettings.getValue(INDEX_QUERY_CACHE_ENABLED_SETTING).booleanValue() ? ((queryCacheProvider = this.forceQueryCacheProvider.get()) == null ? new IndexQueryCache(this.indexSettings, indicesQueryCache) : queryCacheProvider.apply(this.indexSettings, indicesQueryCache)) : new DisabledQueryCache(this.indexSettings);
                indexAnalyzers = this.analysisRegistry.build(this.indexSettings);
                IndexService indexService2 = new IndexService(this.indexSettings, environment, xContentRegistry, new SimilarityService(this.indexSettings, scriptService, this.similarities), shardStoreDeleter, indexAnalyzers, this.engineFactory, circuitBreakerService, bigArrays, threadPool, scriptService, client, queryCache, store, eventListener, searcherWrapperFactory, mapperRegistry, indicesFieldDataCache, this.searchOperationListeners, this.indexOperationListeners, namedWriteableRegistry);
                success = true;
                indexService = indexService2;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(queryCache, indexAnalyzers);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(queryCache, indexAnalyzers);
        }
        return indexService;
    }

    private static IndexStore getIndexStore(IndexSettings indexSettings, Map<String, Function<IndexSettings, IndexStore>> indexStoreFactories) {
        IndexStore store;
        String storeType = indexSettings.getValue(INDEX_STORE_TYPE_SETTING);
        Boolean allowMmap = NODE_STORE_ALLOW_MMAP.get(indexSettings.getNodeSettings());
        Type type = storeType.isEmpty() || Type.FS.getSettingsKey().equals(storeType) ? IndexModule.defaultStoreType(allowMmap) : (IndexModule.isBuiltinType(storeType) ? Type.fromSettingsKey(storeType) : null);
        if (!(allowMmap.booleanValue() || type != Type.MMAPFS && type != Type.HYBRIDFS)) {
            throw new IllegalArgumentException("store type [" + storeType + "] is not allowed because mmap is disabled");
        }
        if (storeType.isEmpty() || IndexModule.isBuiltinType(storeType)) {
            store = new IndexStore(indexSettings);
        } else {
            Function<IndexSettings, IndexStore> factory = indexStoreFactories.get(storeType);
            if (factory == null) {
                throw new IllegalArgumentException("Unknown store type [" + storeType + "]");
            }
            store = factory.apply(indexSettings);
            if (store == null) {
                throw new IllegalStateException("store must not be null");
            }
        }
        return store;
    }

    public MapperService newIndexMapperService(NamedXContentRegistry xContentRegistry, MapperRegistry mapperRegistry, ScriptService scriptService) throws IOException {
        return new MapperService(this.indexSettings, this.analysisRegistry.build(this.indexSettings), xContentRegistry, new SimilarityService(this.indexSettings, scriptService, this.similarities), mapperRegistry, () -> {
            throw new UnsupportedOperationException("no index query shard context available");
        });
    }

    public void forceQueryCacheProvider(BiFunction<IndexSettings, IndicesQueryCache, QueryCache> queryCacheProvider) {
        this.ensureNotFrozen();
        this.forceQueryCacheProvider.set(queryCacheProvider);
    }

    private void ensureNotFrozen() {
        if (this.frozen.get()) {
            throw new IllegalStateException("Can't modify IndexModule once the index service has been created");
        }
    }

    public static interface IndexSearcherWrapperFactory {
        public IndexSearcherWrapper newWrapper(IndexService var1);
    }

    public static enum Type {
        HYBRIDFS("hybridfs"),
        NIOFS("niofs"),
        MMAPFS("mmapfs"),
        SIMPLEFS("simplefs"),
        FS("fs");

        private final String settingsKey;
        private static final Map<String, Type> TYPES;

        private Type(String settingsKey) {
            this.settingsKey = settingsKey;
        }

        public String getSettingsKey() {
            return this.settingsKey;
        }

        public static Type fromSettingsKey(String key) {
            Type type = TYPES.get(key);
            if (type == null) {
                throw new IllegalArgumentException("no matching store type for [" + key + "]");
            }
            return type;
        }

        public boolean match(String setting) {
            return this.getSettingsKey().equals(setting);
        }

        static {
            HashMap<String, Type> types = new HashMap<String, Type>(4);
            for (Type type : Type.values()) {
                types.put(type.settingsKey, type);
            }
            TYPES = Collections.unmodifiableMap(types);
        }
    }
}

