/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.cache;

import conductor.org.elasticsearch.core.internal.io.IOUtils;
import conductor.org.elasticsearch.index.AbstractIndexComponent;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import conductor.org.elasticsearch.index.cache.query.QueryCache;
import java.io.Closeable;
import java.io.IOException;

public class IndexCache
extends AbstractIndexComponent
implements Closeable {
    private final QueryCache queryCache;
    private final BitsetFilterCache bitsetFilterCache;

    public IndexCache(IndexSettings indexSettings, QueryCache queryCache, BitsetFilterCache bitsetFilterCache) {
        super(indexSettings);
        this.queryCache = queryCache;
        this.bitsetFilterCache = bitsetFilterCache;
    }

    public QueryCache query() {
        return this.queryCache;
    }

    public BitsetFilterCache bitsetFilterCache() {
        return this.bitsetFilterCache;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.queryCache, this.bitsetFilterCache);
    }

    public void clear(String reason) {
        this.queryCache.clear(reason);
        this.bitsetFilterCache.clear(reason);
    }
}

