/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.engine;

import conductor.org.apache.lucene.index.DirectoryReader;
import conductor.org.apache.lucene.index.IndexCommit;
import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.SegmentCommitInfo;
import conductor.org.apache.lucene.index.SegmentInfos;
import conductor.org.apache.lucene.index.SoftDeletesDirectoryReaderWrapper;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.ReferenceManager;
import conductor.org.apache.lucene.search.SearcherFactory;
import conductor.org.apache.lucene.search.SearcherManager;
import conductor.org.apache.lucene.store.Directory;
import conductor.org.apache.lucene.store.Lock;
import conductor.org.elasticsearch.Assertions;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.common.lucene.Lucene;
import conductor.org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import conductor.org.elasticsearch.common.util.concurrent.ReleasableLock;
import conductor.org.elasticsearch.core.internal.io.IOUtils;
import conductor.org.elasticsearch.index.engine.Engine;
import conductor.org.elasticsearch.index.engine.EngineConfig;
import conductor.org.elasticsearch.index.engine.EngineException;
import conductor.org.elasticsearch.index.engine.RamAccountingSearcherFactory;
import conductor.org.elasticsearch.index.engine.Segment;
import conductor.org.elasticsearch.index.mapper.MapperService;
import conductor.org.elasticsearch.index.seqno.SeqNoStats;
import conductor.org.elasticsearch.index.seqno.SequenceNumbers;
import conductor.org.elasticsearch.index.shard.DocsStats;
import conductor.org.elasticsearch.index.store.Store;
import conductor.org.elasticsearch.index.translog.Translog;
import conductor.org.elasticsearch.index.translog.TranslogStats;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

public class ReadOnlyEngine
extends Engine {
    private final SegmentInfos lastCommittedSegmentInfos;
    private final SeqNoStats seqNoStats;
    private final TranslogStats translogStats;
    private final SearcherManager searcherManager;
    private final IndexCommit indexCommit;
    private final Lock indexWriterLock;
    private final DocsStats docsStats;
    private final RamAccountingSearcherFactory searcherFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReadOnlyEngine(EngineConfig config, SeqNoStats seqNoStats, TranslogStats translogStats, boolean obtainLock, Function<DirectoryReader, DirectoryReader> readerWrapperFunction) {
        super(config);
        this.searcherFactory = new RamAccountingSearcherFactory(this.engineConfig.getCircuitBreakerService());
        try {
            Store store = config.getStore();
            store.incRef();
            DirectoryReader reader = null;
            Directory directory = store.directory();
            Lock indexWriterLock = null;
            boolean success = false;
            try {
                indexWriterLock = obtainLock ? directory.obtainLock("write.lock") : null;
                this.lastCommittedSegmentInfos = Lucene.readSegmentInfos(directory);
                TranslogStats translogStats2 = this.translogStats = translogStats == null ? new TranslogStats(0, 0L, 0, 0L, 0L) : translogStats;
                if (seqNoStats == null) {
                    seqNoStats = ReadOnlyEngine.buildSeqNoStats(this.lastCommittedSegmentInfos);
                    long globalCheckpoint = this.engineConfig.getGlobalCheckpointSupplier().getAsLong();
                    if (globalCheckpoint != -2L && this.engineConfig.getIndexSettings().getIndexVersionCreated().onOrAfter(Version.V_6_7_0) && seqNoStats.getMaxSeqNo() != globalCheckpoint) {
                        this.assertMaxSeqNoEqualsToGlobalCheckpoint(seqNoStats.getMaxSeqNo(), globalCheckpoint);
                        throw new IllegalStateException("Maximum sequence number [" + seqNoStats.getMaxSeqNo() + "] from last commit does not match global checkpoint [" + globalCheckpoint + "]");
                    }
                }
                this.seqNoStats = seqNoStats;
                this.indexCommit = Lucene.getIndexCommit(this.lastCommittedSegmentInfos, directory);
                reader = this.open(this.indexCommit);
                reader = this.wrapReader(reader, readerWrapperFunction);
                this.searcherManager = new SearcherManager(reader, (SearcherFactory)this.searcherFactory);
                this.docsStats = this.docsStats(this.lastCommittedSegmentInfos);
                this.indexWriterLock = indexWriterLock;
                success = true;
                if (success) return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                Closeable[] closeableArray = new Closeable[3];
                closeableArray[0] = reader;
                closeableArray[1] = indexWriterLock;
                closeableArray[2] = store::decRef;
                IOUtils.close(closeableArray);
                throw throwable;
            }
            Closeable[] closeableArray = new Closeable[3];
            closeableArray[0] = reader;
            closeableArray[1] = indexWriterLock;
            closeableArray[2] = store::decRef;
            IOUtils.close(closeableArray);
            return;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected void assertMaxSeqNoEqualsToGlobalCheckpoint(long maxSeqNo, long globalCheckpoint) {
        if (Assertions.ENABLED) assert (false) : "max seq. no. [" + maxSeqNo + "] does not match [" + globalCheckpoint + "]";
    }

    @Override
    public void verifyEngineBeforeIndexClosing() throws IllegalStateException {
    }

    protected final DirectoryReader wrapReader(DirectoryReader reader, Function<DirectoryReader, DirectoryReader> readerWrapperFunction) throws IOException {
        reader = ElasticsearchDirectoryReader.wrap(reader, this.engineConfig.getShardId());
        if (this.engineConfig.getIndexSettings().isSoftDeleteEnabled()) {
            reader = new SoftDeletesDirectoryReaderWrapper(reader, "__soft_deletes");
        }
        return readerWrapperFunction.apply(reader);
    }

    protected DirectoryReader open(IndexCommit commit) throws IOException {
        return DirectoryReader.open(commit);
    }

    private DocsStats docsStats(SegmentInfos lastCommittedSegmentInfos) {
        long numDocs = 0L;
        long numDeletedDocs = 0L;
        long sizeInBytes = 0L;
        if (lastCommittedSegmentInfos != null) {
            for (SegmentCommitInfo segmentCommitInfo : lastCommittedSegmentInfos) {
                numDocs += (long)(segmentCommitInfo.info.maxDoc() - segmentCommitInfo.getDelCount() - segmentCommitInfo.getSoftDelCount());
                numDeletedDocs += (long)(segmentCommitInfo.getDelCount() + segmentCommitInfo.getSoftDelCount());
                try {
                    sizeInBytes += segmentCommitInfo.sizeInBytes();
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to get size for [" + segmentCommitInfo.info.name + "]", e);
                }
            }
        }
        return new DocsStats(numDocs, numDeletedDocs, sizeInBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeNoLock(String reason, CountDownLatch closedLatch) {
        if (this.isClosed.compareAndSet(false, true)) {
            try {
                Closeable[] closeableArray = new Closeable[3];
                closeableArray[0] = this.searcherManager;
                closeableArray[1] = this.indexWriterLock;
                closeableArray[2] = this.store::decRef;
                IOUtils.close(closeableArray);
            }
            catch (Exception ex) {
                this.logger.warn("failed to close searcher", (Throwable)ex);
            }
            finally {
                closedLatch.countDown();
            }
        }
    }

    public static SeqNoStats buildSeqNoStats(SegmentInfos infos) {
        SequenceNumbers.CommitInfo seqNoStats = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(infos.userData.entrySet());
        long maxSeqNo = seqNoStats.maxSeqNo;
        long localCheckpoint = seqNoStats.localCheckpoint;
        return new SeqNoStats(maxSeqNo, localCheckpoint, localCheckpoint);
    }

    @Override
    public Engine.GetResult get(Engine.Get get, BiFunction<String, Engine.SearcherScope, Engine.Searcher> searcherFactory) throws EngineException {
        return this.getFromSearcher(get, searcherFactory, Engine.SearcherScope.EXTERNAL);
    }

    @Override
    protected ReferenceManager<IndexSearcher> getReferenceManager(Engine.SearcherScope scope) {
        return this.searcherManager;
    }

    @Override
    protected SegmentInfos getLastCommittedSegmentInfos() {
        return this.lastCommittedSegmentInfos;
    }

    @Override
    public String getHistoryUUID() {
        return this.lastCommittedSegmentInfos.userData.get("history_uuid");
    }

    @Override
    public long getWritingBytes() {
        return 0L;
    }

    @Override
    public long getIndexThrottleTimeInMillis() {
        return 0L;
    }

    @Override
    public boolean isThrottled() {
        return false;
    }

    @Override
    public Engine.IndexResult index(Engine.Index index) {
        assert (false) : "this should not be called";
        throw new UnsupportedOperationException("indexing is not supported on a read-only engine");
    }

    @Override
    public Engine.DeleteResult delete(Engine.Delete delete) {
        assert (false) : "this should not be called";
        throw new UnsupportedOperationException("deletes are not supported on a read-only engine");
    }

    @Override
    public Engine.NoOpResult noOp(Engine.NoOp noOp) {
        assert (false) : "this should not be called";
        throw new UnsupportedOperationException("no-ops are not supported on a read-only engine");
    }

    @Override
    public boolean isTranslogSyncNeeded() {
        return false;
    }

    @Override
    public boolean ensureTranslogSynced(Stream<Translog.Location> locations) {
        return false;
    }

    @Override
    public void syncTranslog() {
    }

    @Override
    public Closeable acquireRetentionLock() {
        return () -> {};
    }

    @Override
    public Translog.Snapshot newChangesSnapshot(String source, MapperService mapperService, long fromSeqNo, long toSeqNo, boolean requiredFullRange) throws IOException {
        if (!this.engineConfig.getIndexSettings().isSoftDeleteEnabled()) {
            throw new IllegalStateException("accessing changes snapshot requires soft-deletes enabled");
        }
        return this.readHistoryOperations(source, mapperService, fromSeqNo);
    }

    @Override
    public Translog.Snapshot readHistoryOperations(String source, MapperService mapperService, long startingSeqNo) throws IOException {
        return this.newEmptySnapshot();
    }

    @Override
    public int estimateNumberOfHistoryOperations(String source, MapperService mapperService, long startingSeqNo) throws IOException {
        return 0;
    }

    @Override
    public boolean hasCompleteOperationHistory(String source, MapperService mapperService, long startingSeqNo) throws IOException {
        return false;
    }

    @Override
    public long getMinRetainedSeqNo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TranslogStats getTranslogStats() {
        return this.translogStats;
    }

    @Override
    public Translog.Location getTranslogLastWriteLocation() {
        return new Translog.Location(0L, 0L, 0);
    }

    @Override
    public long getLocalCheckpoint() {
        return this.seqNoStats.getLocalCheckpoint();
    }

    @Override
    public SeqNoStats getSeqNoStats(long globalCheckpoint) {
        return new SeqNoStats(this.seqNoStats.getMaxSeqNo(), this.seqNoStats.getLocalCheckpoint(), globalCheckpoint);
    }

    @Override
    public long getLastSyncedGlobalCheckpoint() {
        return this.seqNoStats.getGlobalCheckpoint();
    }

    @Override
    public long getIndexBufferRAMBytesUsed() {
        return 0L;
    }

    @Override
    public List<Segment> segments(boolean verbose) {
        return Arrays.asList(this.getSegmentInfo(this.lastCommittedSegmentInfos, verbose));
    }

    @Override
    public void refresh(String source) {
    }

    @Override
    public void writeIndexingBuffer() throws EngineException {
    }

    @Override
    public boolean shouldPeriodicallyFlush() {
        return false;
    }

    @Override
    public Engine.SyncedFlushResult syncFlush(String syncId, Engine.CommitId expectedCommitId) {
        throw new UnsupportedOperationException("syncedFlush is not supported on a read-only engine");
    }

    @Override
    public Engine.CommitId flush(boolean force, boolean waitIfOngoing) throws EngineException {
        return new Engine.CommitId(this.lastCommittedSegmentInfos.getId());
    }

    @Override
    public void forceMerge(boolean flush, int maxNumSegments, boolean onlyExpungeDeletes, boolean upgrade, boolean upgradeOnlyAncientSegments) {
    }

    @Override
    public Engine.IndexCommitRef acquireLastIndexCommit(boolean flushFirst) {
        this.store.incRef();
        return new Engine.IndexCommitRef(this.indexCommit, this.store::decRef);
    }

    @Override
    public Engine.IndexCommitRef acquireSafeIndexCommit() {
        return this.acquireLastIndexCommit(false);
    }

    @Override
    public void activateThrottling() {
    }

    @Override
    public void deactivateThrottling() {
    }

    @Override
    public void trimUnreferencedTranslogFiles() {
    }

    @Override
    public boolean shouldRollTranslogGeneration() {
        return false;
    }

    @Override
    public void rollTranslogGeneration() {
    }

    @Override
    public int restoreLocalHistoryFromTranslog(Engine.TranslogRecoveryRunner translogRecoveryRunner) {
        return 0;
    }

    @Override
    public int fillSeqNoGaps(long primaryTerm) {
        return 0;
    }

    @Override
    public Engine recoverFromTranslog(Engine.TranslogRecoveryRunner translogRecoveryRunner, long recoverUpToSeqNo) {
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            try (Translog.Snapshot snapshot = this.newEmptySnapshot();){
                translogRecoveryRunner.run(this, snapshot);
            }
            catch (Exception e) {
                throw new EngineException(this.shardId, "failed to recover from empty translog snapshot", e, new Object[0]);
            }
        }
        return this;
    }

    @Override
    public void skipTranslogRecovery() {
    }

    @Override
    public void trimOperationsFromTranslog(long belowTerm, long aboveSeqNo) {
    }

    @Override
    public void maybePruneDeletes() {
    }

    @Override
    public DocsStats docStats() {
        return this.docsStats;
    }

    @Override
    public void updateMaxUnsafeAutoIdTimestamp(long newTimestamp) {
    }

    @Override
    public void reinitializeMaxSeqNoOfUpdatesOrDeletes() {
        this.advanceMaxSeqNoOfUpdatesOrDeletes(this.seqNoStats.getMaxSeqNo());
    }

    protected void processReaders(IndexReader reader, IndexReader previousReader) {
        this.searcherFactory.processReaders(reader, previousReader);
    }

    @Override
    public boolean refreshNeeded() {
        return false;
    }

    private Translog.Snapshot newEmptySnapshot() {
        return new Translog.Snapshot(){

            @Override
            public void close() {
            }

            @Override
            public int totalOperations() {
                return 0;
            }

            @Override
            public Translog.Operation next() {
                return null;
            }
        };
    }
}

