/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.fielddata.plain;

import conductor.org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import conductor.org.elasticsearch.index.fielddata.FieldData;
import conductor.org.elasticsearch.index.fielddata.IndexNumericFieldData;
import conductor.org.elasticsearch.index.fielddata.ScriptDocValues;
import conductor.org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import conductor.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import conductor.org.elasticsearch.script.JodaCompatibleZonedDateTime;
import conductor.org.joda.time.DateTime;
import conductor.org.joda.time.DateTimeZone;
import java.io.IOException;

abstract class AtomicLongFieldData
implements AtomicNumericFieldData {
    private final long ramBytesUsed;
    private final IndexNumericFieldData.NumericType numericType;

    AtomicLongFieldData(long ramBytesUsed, IndexNumericFieldData.NumericType numericType) {
        this.ramBytesUsed = ramBytesUsed;
        this.numericType = numericType;
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    @Override
    public final ScriptDocValues<?> getLegacyFieldValues() {
        switch (this.numericType) {
            case DATE: {
                final ScriptDocValues.Dates realDV = new ScriptDocValues.Dates(this.getLongValues());
                return new ScriptDocValues<DateTime>(){

                    @Override
                    public int size() {
                        return realDV.size();
                    }

                    @Override
                    public DateTime get(int index) {
                        JodaCompatibleZonedDateTime dt = realDV.get(index);
                        return new DateTime(dt.toInstant().toEpochMilli(), DateTimeZone.UTC);
                    }

                    @Override
                    public void setNextDocId(int docId) throws IOException {
                        realDV.setNextDocId(docId);
                    }
                };
            }
        }
        return this.getScriptValues();
    }

    @Override
    public final ScriptDocValues<?> getScriptValues() {
        switch (this.numericType) {
            case DATE: {
                return new ScriptDocValues.Dates(this.getLongValues());
            }
            case BOOLEAN: {
                return new ScriptDocValues.Booleans(this.getLongValues());
            }
        }
        return new ScriptDocValues.Longs(this.getLongValues());
    }

    @Override
    public final SortedBinaryDocValues getBytesValues() {
        return FieldData.toString(this.getLongValues());
    }

    @Override
    public final SortedNumericDoubleValues getDoubleValues() {
        return FieldData.castToDouble(this.getLongValues());
    }

    @Override
    public void close() {
    }
}

