/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.query;

import conductor.org.apache.lucene.queryparser.classic.QueryParser;
import conductor.org.apache.lucene.search.BooleanClause;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.util.CollectionUtils;
import java.io.IOException;
import java.util.Locale;

public enum Operator implements Writeable
{
    OR,
    AND;


    public BooleanClause.Occur toBooleanClauseOccur() {
        switch (this) {
            case OR: {
                return BooleanClause.Occur.SHOULD;
            }
            case AND: {
                return BooleanClause.Occur.MUST;
            }
        }
        throw Operator.newOperatorException(this.toString());
    }

    public QueryParser.Operator toQueryParserOperator() {
        switch (this) {
            case OR: {
                return QueryParser.Operator.OR;
            }
            case AND: {
                return QueryParser.Operator.AND;
            }
        }
        throw Operator.newOperatorException(this.toString());
    }

    public static Operator readFromStream(StreamInput in) throws IOException {
        return in.readEnum(Operator.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this);
    }

    public static Operator fromString(String op) {
        return Operator.valueOf(op.toUpperCase(Locale.ROOT));
    }

    private static IllegalArgumentException newOperatorException(String op) {
        return new IllegalArgumentException("operator needs to be either " + CollectionUtils.arrayAsArrayList(Operator.values()) + ", but not [" + op + "]");
    }
}

