/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.query;

import conductor.org.apache.lucene.search.join.ScoreMode;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.geo.GeoPoint;
import conductor.org.elasticsearch.common.geo.ShapeRelation;
import conductor.org.elasticsearch.common.geo.builders.ShapeBuilder;
import conductor.org.elasticsearch.index.query.BoolQueryBuilder;
import conductor.org.elasticsearch.index.query.BoostingQueryBuilder;
import conductor.org.elasticsearch.index.query.CommonTermsQueryBuilder;
import conductor.org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import conductor.org.elasticsearch.index.query.DisMaxQueryBuilder;
import conductor.org.elasticsearch.index.query.ExistsQueryBuilder;
import conductor.org.elasticsearch.index.query.FieldMaskingSpanQueryBuilder;
import conductor.org.elasticsearch.index.query.FuzzyQueryBuilder;
import conductor.org.elasticsearch.index.query.GeoBoundingBoxQueryBuilder;
import conductor.org.elasticsearch.index.query.GeoDistanceQueryBuilder;
import conductor.org.elasticsearch.index.query.GeoPolygonQueryBuilder;
import conductor.org.elasticsearch.index.query.GeoShapeQueryBuilder;
import conductor.org.elasticsearch.index.query.IdsQueryBuilder;
import conductor.org.elasticsearch.index.query.MatchAllQueryBuilder;
import conductor.org.elasticsearch.index.query.MatchPhrasePrefixQueryBuilder;
import conductor.org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import conductor.org.elasticsearch.index.query.MatchQueryBuilder;
import conductor.org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import conductor.org.elasticsearch.index.query.MultiMatchQueryBuilder;
import conductor.org.elasticsearch.index.query.MultiTermQueryBuilder;
import conductor.org.elasticsearch.index.query.NestedQueryBuilder;
import conductor.org.elasticsearch.index.query.PrefixQueryBuilder;
import conductor.org.elasticsearch.index.query.QueryBuilder;
import conductor.org.elasticsearch.index.query.QueryStringQueryBuilder;
import conductor.org.elasticsearch.index.query.RangeQueryBuilder;
import conductor.org.elasticsearch.index.query.RegexpQueryBuilder;
import conductor.org.elasticsearch.index.query.ScriptQueryBuilder;
import conductor.org.elasticsearch.index.query.SimpleQueryStringBuilder;
import conductor.org.elasticsearch.index.query.SpanContainingQueryBuilder;
import conductor.org.elasticsearch.index.query.SpanFirstQueryBuilder;
import conductor.org.elasticsearch.index.query.SpanMultiTermQueryBuilder;
import conductor.org.elasticsearch.index.query.SpanNearQueryBuilder;
import conductor.org.elasticsearch.index.query.SpanNotQueryBuilder;
import conductor.org.elasticsearch.index.query.SpanOrQueryBuilder;
import conductor.org.elasticsearch.index.query.SpanQueryBuilder;
import conductor.org.elasticsearch.index.query.SpanTermQueryBuilder;
import conductor.org.elasticsearch.index.query.SpanWithinQueryBuilder;
import conductor.org.elasticsearch.index.query.TermQueryBuilder;
import conductor.org.elasticsearch.index.query.TermsQueryBuilder;
import conductor.org.elasticsearch.index.query.TypeQueryBuilder;
import conductor.org.elasticsearch.index.query.WildcardQueryBuilder;
import conductor.org.elasticsearch.index.query.WrapperQueryBuilder;
import conductor.org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import conductor.org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import conductor.org.elasticsearch.indices.TermsLookup;
import conductor.org.elasticsearch.script.Script;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public final class QueryBuilders {
    private QueryBuilders() {
    }

    public static MatchAllQueryBuilder matchAllQuery() {
        return new MatchAllQueryBuilder();
    }

    public static MatchQueryBuilder matchQuery(String name, Object text) {
        return new MatchQueryBuilder(name, text);
    }

    public static CommonTermsQueryBuilder commonTermsQuery(String fieldName, Object text) {
        return new CommonTermsQueryBuilder(fieldName, text);
    }

    public static MultiMatchQueryBuilder multiMatchQuery(Object text, String ... fieldNames) {
        return new MultiMatchQueryBuilder(text, fieldNames);
    }

    public static MatchPhraseQueryBuilder matchPhraseQuery(String name, Object text) {
        return new MatchPhraseQueryBuilder(name, text);
    }

    public static MatchPhrasePrefixQueryBuilder matchPhrasePrefixQuery(String name, Object text) {
        return new MatchPhrasePrefixQueryBuilder(name, text);
    }

    public static DisMaxQueryBuilder disMaxQuery() {
        return new DisMaxQueryBuilder();
    }

    public static IdsQueryBuilder idsQuery() {
        return new IdsQueryBuilder();
    }

    public static IdsQueryBuilder idsQuery(String ... types) {
        return new IdsQueryBuilder().types(types);
    }

    public static TermQueryBuilder termQuery(String name, String value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, int value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, long value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, float value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, double value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, boolean value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, Object value) {
        return new TermQueryBuilder(name, value);
    }

    public static FuzzyQueryBuilder fuzzyQuery(String name, String value) {
        return new FuzzyQueryBuilder(name, value);
    }

    public static FuzzyQueryBuilder fuzzyQuery(String name, Object value) {
        return new FuzzyQueryBuilder(name, value);
    }

    public static PrefixQueryBuilder prefixQuery(String name, String prefix) {
        return new PrefixQueryBuilder(name, prefix);
    }

    public static RangeQueryBuilder rangeQuery(String name) {
        return new RangeQueryBuilder(name);
    }

    public static WildcardQueryBuilder wildcardQuery(String name, String query) {
        return new WildcardQueryBuilder(name, query);
    }

    public static RegexpQueryBuilder regexpQuery(String name, String regexp) {
        return new RegexpQueryBuilder(name, regexp);
    }

    public static QueryStringQueryBuilder queryStringQuery(String queryString) {
        return new QueryStringQueryBuilder(queryString);
    }

    public static SimpleQueryStringBuilder simpleQueryStringQuery(String queryString) {
        return new SimpleQueryStringBuilder(queryString);
    }

    public static BoostingQueryBuilder boostingQuery(QueryBuilder positiveQuery, QueryBuilder negativeQuery) {
        return new BoostingQueryBuilder(positiveQuery, negativeQuery);
    }

    public static BoolQueryBuilder boolQuery() {
        return new BoolQueryBuilder();
    }

    public static SpanTermQueryBuilder spanTermQuery(String name, String value) {
        return new SpanTermQueryBuilder(name, value);
    }

    public static SpanTermQueryBuilder spanTermQuery(String name, int value) {
        return new SpanTermQueryBuilder(name, value);
    }

    public static SpanTermQueryBuilder spanTermQuery(String name, long value) {
        return new SpanTermQueryBuilder(name, value);
    }

    public static SpanTermQueryBuilder spanTermQuery(String name, float value) {
        return new SpanTermQueryBuilder(name, value);
    }

    public static SpanTermQueryBuilder spanTermQuery(String name, double value) {
        return new SpanTermQueryBuilder(name, value);
    }

    public static SpanFirstQueryBuilder spanFirstQuery(SpanQueryBuilder match, int end) {
        return new SpanFirstQueryBuilder(match, end);
    }

    public static SpanNearQueryBuilder spanNearQuery(SpanQueryBuilder initialClause, int slop) {
        return new SpanNearQueryBuilder(initialClause, slop);
    }

    public static SpanNotQueryBuilder spanNotQuery(SpanQueryBuilder include, SpanQueryBuilder exclude) {
        return new SpanNotQueryBuilder(include, exclude);
    }

    public static SpanOrQueryBuilder spanOrQuery(SpanQueryBuilder initialClause) {
        return new SpanOrQueryBuilder(initialClause);
    }

    public static SpanWithinQueryBuilder spanWithinQuery(SpanQueryBuilder big, SpanQueryBuilder little) {
        return new SpanWithinQueryBuilder(big, little);
    }

    public static SpanContainingQueryBuilder spanContainingQuery(SpanQueryBuilder big, SpanQueryBuilder little) {
        return new SpanContainingQueryBuilder(big, little);
    }

    public static SpanMultiTermQueryBuilder spanMultiTermQueryBuilder(MultiTermQueryBuilder multiTermQueryBuilder) {
        return new SpanMultiTermQueryBuilder(multiTermQueryBuilder);
    }

    public static FieldMaskingSpanQueryBuilder fieldMaskingSpanQuery(SpanQueryBuilder query, String field) {
        return new FieldMaskingSpanQueryBuilder(query, field);
    }

    public static ConstantScoreQueryBuilder constantScoreQuery(QueryBuilder queryBuilder) {
        return new ConstantScoreQueryBuilder(queryBuilder);
    }

    public static FunctionScoreQueryBuilder functionScoreQuery(QueryBuilder queryBuilder) {
        return new FunctionScoreQueryBuilder(queryBuilder);
    }

    public static FunctionScoreQueryBuilder functionScoreQuery(QueryBuilder queryBuilder, FunctionScoreQueryBuilder.FilterFunctionBuilder[] filterFunctionBuilders) {
        return new FunctionScoreQueryBuilder(queryBuilder, filterFunctionBuilders);
    }

    public static FunctionScoreQueryBuilder functionScoreQuery(FunctionScoreQueryBuilder.FilterFunctionBuilder[] filterFunctionBuilders) {
        return new FunctionScoreQueryBuilder(filterFunctionBuilders);
    }

    public static FunctionScoreQueryBuilder functionScoreQuery(ScoreFunctionBuilder function) {
        return new FunctionScoreQueryBuilder(function);
    }

    public static FunctionScoreQueryBuilder functionScoreQuery(QueryBuilder queryBuilder, ScoreFunctionBuilder function) {
        return new FunctionScoreQueryBuilder(queryBuilder, function);
    }

    public static MoreLikeThisQueryBuilder moreLikeThisQuery(String[] fields, String[] likeTexts, MoreLikeThisQueryBuilder.Item[] likeItems) {
        return new MoreLikeThisQueryBuilder(fields, likeTexts, likeItems);
    }

    public static MoreLikeThisQueryBuilder moreLikeThisQuery(String[] likeTexts, MoreLikeThisQueryBuilder.Item[] likeItems) {
        return QueryBuilders.moreLikeThisQuery(null, likeTexts, likeItems);
    }

    public static MoreLikeThisQueryBuilder moreLikeThisQuery(String[] likeTexts) {
        return QueryBuilders.moreLikeThisQuery(null, likeTexts, null);
    }

    public static MoreLikeThisQueryBuilder moreLikeThisQuery(MoreLikeThisQueryBuilder.Item[] likeItems) {
        return QueryBuilders.moreLikeThisQuery(null, null, likeItems);
    }

    public static NestedQueryBuilder nestedQuery(String path, QueryBuilder query, ScoreMode scoreMode) {
        return new NestedQueryBuilder(path, query, scoreMode);
    }

    public static TermsQueryBuilder termsQuery(String name, String ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder termsQuery(String name, int ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder termsQuery(String name, long ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder termsQuery(String name, float ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder termsQuery(String name, double ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder termsQuery(String name, Object ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder termsQuery(String name, Collection<?> values) {
        return new TermsQueryBuilder(name, values);
    }

    public static WrapperQueryBuilder wrapperQuery(String source) {
        return new WrapperQueryBuilder(source);
    }

    public static WrapperQueryBuilder wrapperQuery(BytesReference source) {
        return new WrapperQueryBuilder(source);
    }

    public static WrapperQueryBuilder wrapperQuery(byte[] source) {
        return new WrapperQueryBuilder(source);
    }

    public static TypeQueryBuilder typeQuery(String type) {
        return new TypeQueryBuilder(type);
    }

    public static TermsQueryBuilder termsLookupQuery(String name, TermsLookup termsLookup) {
        return new TermsQueryBuilder(name, termsLookup);
    }

    public static ScriptQueryBuilder scriptQuery(Script script) {
        return new ScriptQueryBuilder(script);
    }

    public static GeoDistanceQueryBuilder geoDistanceQuery(String name) {
        return new GeoDistanceQueryBuilder(name);
    }

    public static GeoBoundingBoxQueryBuilder geoBoundingBoxQuery(String name) {
        return new GeoBoundingBoxQueryBuilder(name);
    }

    public static GeoPolygonQueryBuilder geoPolygonQuery(String name, List<GeoPoint> points) {
        return new GeoPolygonQueryBuilder(name, points);
    }

    public static GeoShapeQueryBuilder geoShapeQuery(String name, ShapeBuilder shape) throws IOException {
        return new GeoShapeQueryBuilder(name, shape);
    }

    public static GeoShapeQueryBuilder geoShapeQuery(String name, String indexedShapeId, String indexedShapeType) {
        return new GeoShapeQueryBuilder(name, indexedShapeId, indexedShapeType);
    }

    public static GeoShapeQueryBuilder geoIntersectionQuery(String name, ShapeBuilder shape) throws IOException {
        GeoShapeQueryBuilder builder = QueryBuilders.geoShapeQuery(name, shape);
        builder.relation(ShapeRelation.INTERSECTS);
        return builder;
    }

    public static GeoShapeQueryBuilder geoIntersectionQuery(String name, String indexedShapeId, String indexedShapeType) {
        GeoShapeQueryBuilder builder = QueryBuilders.geoShapeQuery(name, indexedShapeId, indexedShapeType);
        builder.relation(ShapeRelation.INTERSECTS);
        return builder;
    }

    public static GeoShapeQueryBuilder geoWithinQuery(String name, ShapeBuilder shape) throws IOException {
        GeoShapeQueryBuilder builder = QueryBuilders.geoShapeQuery(name, shape);
        builder.relation(ShapeRelation.WITHIN);
        return builder;
    }

    public static GeoShapeQueryBuilder geoWithinQuery(String name, String indexedShapeId, String indexedShapeType) {
        GeoShapeQueryBuilder builder = QueryBuilders.geoShapeQuery(name, indexedShapeId, indexedShapeType);
        builder.relation(ShapeRelation.WITHIN);
        return builder;
    }

    public static GeoShapeQueryBuilder geoDisjointQuery(String name, ShapeBuilder shape) throws IOException {
        GeoShapeQueryBuilder builder = QueryBuilders.geoShapeQuery(name, shape);
        builder.relation(ShapeRelation.DISJOINT);
        return builder;
    }

    public static GeoShapeQueryBuilder geoDisjointQuery(String name, String indexedShapeId, String indexedShapeType) {
        GeoShapeQueryBuilder builder = QueryBuilders.geoShapeQuery(name, indexedShapeId, indexedShapeType);
        builder.relation(ShapeRelation.DISJOINT);
        return builder;
    }

    public static ExistsQueryBuilder existsQuery(String name) {
        return new ExistsQueryBuilder(name);
    }
}

