/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.query;

import conductor.org.apache.lucene.queries.SpanMatchNoDocsQuery;
import conductor.org.apache.lucene.search.BoostQuery;
import conductor.org.apache.lucene.search.ConstantScoreQuery;
import conductor.org.apache.lucene.search.MatchNoDocsQuery;
import conductor.org.apache.lucene.search.MultiTermQuery;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.TopTermsRewrite;
import conductor.org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.ParsingException;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.lucene.search.SpanBooleanQueryRewriteWithMaxClause;
import conductor.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.index.query.AbstractQueryBuilder;
import conductor.org.elasticsearch.index.query.MultiTermQueryBuilder;
import conductor.org.elasticsearch.index.query.PrefixQueryBuilder;
import conductor.org.elasticsearch.index.query.QueryBuilder;
import conductor.org.elasticsearch.index.query.QueryShardContext;
import conductor.org.elasticsearch.index.query.SpanQueryBuilder;
import conductor.org.elasticsearch.index.query.support.QueryParsers;
import java.io.IOException;
import java.util.Objects;

public class SpanMultiTermQueryBuilder
extends AbstractQueryBuilder<SpanMultiTermQueryBuilder>
implements SpanQueryBuilder {
    public static final String NAME = "span_multi";
    private static final ParseField MATCH_FIELD = new ParseField("match", new String[0]);
    private final MultiTermQueryBuilder multiTermQueryBuilder;

    public SpanMultiTermQueryBuilder(MultiTermQueryBuilder multiTermQueryBuilder) {
        if (multiTermQueryBuilder == null) {
            throw new IllegalArgumentException("inner multi term query cannot be null");
        }
        this.multiTermQueryBuilder = multiTermQueryBuilder;
    }

    public SpanMultiTermQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.multiTermQueryBuilder = (MultiTermQueryBuilder)in.readNamedWriteable(QueryBuilder.class);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.multiTermQueryBuilder);
    }

    public MultiTermQueryBuilder innerQuery() {
        return this.multiTermQueryBuilder;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(MATCH_FIELD.getPreferredName());
        this.multiTermQueryBuilder.toXContent(builder, params);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static SpanMultiTermQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        MultiTermQueryBuilder subQuery = null;
        String queryName = null;
        float boost = 1.0f;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (MATCH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    QueryBuilder query = SpanMultiTermQueryBuilder.parseInnerQueryBuilder(parser);
                    if (!(query instanceof MultiTermQueryBuilder)) {
                        throw new ParsingException(parser.getTokenLocation(), "[span_multi] [" + MATCH_FIELD.getPreferredName() + "] must be of type multi term query", new Object[0]);
                    }
                    subQuery = (MultiTermQueryBuilder)query;
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[span_multi] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (!token.isValue()) continue;
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[span_multi] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (subQuery == null) {
            throw new ParsingException(parser.getTokenLocation(), "[span_multi] must have [" + MATCH_FIELD.getPreferredName() + "] multi term query clause", new Object[0]);
        }
        return (SpanMultiTermQueryBuilder)((SpanMultiTermQueryBuilder)new SpanMultiTermQueryBuilder(subQuery).queryName(queryName)).boost(boost);
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        if (this.multiTermQueryBuilder instanceof PrefixQueryBuilder) {
            SpanMultiTermQueryWrapper.SpanRewriteMethod spanRewriteMethod;
            PrefixQueryBuilder prefixBuilder = (PrefixQueryBuilder)this.multiTermQueryBuilder;
            MappedFieldType fieldType = context.fieldMapper(this.multiTermQueryBuilder.fieldName());
            if (fieldType == null) {
                return new SpanMatchNoDocsQuery(this.multiTermQueryBuilder.fieldName(), "unknown field");
            }
            if (prefixBuilder.rewrite() != null) {
                MultiTermQuery.RewriteMethod rewriteMethod = QueryParsers.parseRewriteMethod(prefixBuilder.rewrite(), null, LoggingDeprecationHandler.INSTANCE);
                if (rewriteMethod instanceof TopTermsRewrite) {
                    TopTermsRewrite innerRewrite = (TopTermsRewrite)rewriteMethod;
                    spanRewriteMethod = new SpanMultiTermQueryWrapper.TopTermsSpanBooleanQueryRewrite(innerRewrite.getSize());
                } else {
                    spanRewriteMethod = new SpanBooleanQueryRewriteWithMaxClause();
                }
            } else {
                spanRewriteMethod = new SpanBooleanQueryRewriteWithMaxClause();
            }
            return fieldType.spanPrefixQuery(prefixBuilder.value(), spanRewriteMethod, context);
        }
        Query subQuery = this.multiTermQueryBuilder.toQuery(context);
        while (true) {
            if (subQuery instanceof ConstantScoreQuery) {
                subQuery = ((ConstantScoreQuery)subQuery).getQuery();
                continue;
            }
            if (!(subQuery instanceof BoostQuery)) break;
            BoostQuery boostQuery = (BoostQuery)subQuery;
            subQuery = boostQuery.getQuery();
        }
        if (subQuery instanceof MatchNoDocsQuery) {
            return new SpanMatchNoDocsQuery(this.multiTermQueryBuilder.fieldName(), subQuery.toString());
        }
        if (!(subQuery instanceof MultiTermQuery)) {
            throw new UnsupportedOperationException("unsupported inner query, should be " + MultiTermQuery.class.getName() + " but was " + subQuery.getClass().getName());
        }
        MultiTermQuery multiTermQuery = (MultiTermQuery)subQuery;
        SpanMultiTermQueryWrapper<MultiTermQuery> wrapper = new SpanMultiTermQueryWrapper<MultiTermQuery>(multiTermQuery);
        if (!(multiTermQuery.getRewriteMethod() instanceof TopTermsRewrite)) {
            wrapper.setRewriteMethod(new SpanBooleanQueryRewriteWithMaxClause());
        }
        return wrapper;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.multiTermQueryBuilder);
    }

    @Override
    protected boolean doEquals(SpanMultiTermQueryBuilder other) {
        return Objects.equals(this.multiTermQueryBuilder, other.multiTermQueryBuilder);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

