/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.reindex;

import conductor.org.elasticsearch.action.search.SearchRequest;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import conductor.org.elasticsearch.script.Script;
import conductor.org.elasticsearch.tasks.TaskId;
import java.io.IOException;

public abstract class AbstractBulkIndexByScrollRequest<Self extends AbstractBulkIndexByScrollRequest<Self>>
extends AbstractBulkByScrollRequest<Self> {
    private Script script;

    public AbstractBulkIndexByScrollRequest() {
    }

    protected AbstractBulkIndexByScrollRequest(SearchRequest searchRequest, boolean setDefaults) {
        super(searchRequest, setDefaults);
    }

    public Script getScript() {
        return this.script;
    }

    public Self setScript(@Nullable Script script) {
        this.script = script;
        return (Self)((AbstractBulkIndexByScrollRequest)this.self());
    }

    @Override
    protected Self doForSlice(Self request, TaskId slicingTask, int totalSlices) {
        return ((AbstractBulkIndexByScrollRequest)super.doForSlice(request, slicingTask, totalSlices)).setScript(this.script);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.readBoolean()) {
            this.script = new Script(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable(this.script);
    }

    @Override
    protected void searchToString(StringBuilder b) {
        super.searchToString(b);
        if (this.script != null) {
            b.append(" updated with ").append(this.script);
        }
    }
}

