/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.reindex;

import conductor.org.elasticsearch.action.Action;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsRequest;
import conductor.org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsResponse;
import conductor.org.elasticsearch.action.search.SearchRequest;
import conductor.org.elasticsearch.client.Client;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.index.Index;
import conductor.org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import conductor.org.elasticsearch.index.reindex.BulkByScrollResponse;
import conductor.org.elasticsearch.index.reindex.BulkByScrollTask;
import conductor.org.elasticsearch.index.reindex.LeaderBulkByScrollTaskState;
import conductor.org.elasticsearch.search.builder.SearchSourceBuilder;
import conductor.org.elasticsearch.search.slice.SliceBuilder;
import conductor.org.elasticsearch.tasks.TaskId;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;

class BulkByScrollParallelizationHelper {
    static final int AUTO_SLICE_CEILING = 20;

    private BulkByScrollParallelizationHelper() {
    }

    static <Request extends AbstractBulkByScrollRequest<Request>> void startSlicedAction(Request request, BulkByScrollTask task, Action<Request, BulkByScrollResponse, ?> action, ActionListener<BulkByScrollResponse> listener, Client client, DiscoveryNode node, Runnable workerAction) {
        if (request.getSlices() == 0) {
            ClusterSearchShardsRequest shardsRequest = new ClusterSearchShardsRequest();
            shardsRequest.indices(request.getSearchRequest().indices());
            client.admin().cluster().searchShards(shardsRequest, ActionListener.wrap(response -> {
                int actualNumSlices = BulkByScrollParallelizationHelper.countSlicesBasedOnShards(response);
                BulkByScrollParallelizationHelper.sliceConditionally(request, task, action, listener, client, node, workerAction, actualNumSlices);
            }, listener::onFailure));
        } else {
            BulkByScrollParallelizationHelper.sliceConditionally(request, task, action, listener, client, node, workerAction, request.getSlices());
        }
    }

    private static <Request extends AbstractBulkByScrollRequest<Request>> void sliceConditionally(Request request, BulkByScrollTask task, Action<Request, BulkByScrollResponse, ?> action, ActionListener<BulkByScrollResponse> listener, Client client, DiscoveryNode node, Runnable workerAction, int slices) {
        if (slices > 1) {
            task.setWorkerCount(slices);
            BulkByScrollParallelizationHelper.sendSubRequests(client, action, node.getId(), task, request, listener);
        } else {
            SliceBuilder sliceBuilder = request.getSearchRequest().source().slice();
            Integer sliceId = sliceBuilder == null ? null : Integer.valueOf(sliceBuilder.getId());
            task.setWorker(request.getRequestsPerSecond(), sliceId);
            workerAction.run();
        }
    }

    private static int countSlicesBasedOnShards(ClusterSearchShardsResponse response) {
        Map<Index, Integer> countsByIndex = Arrays.stream(response.getGroups()).collect(Collectors.toMap(group -> group.getShardId().getIndex(), group -> 1, (sum, term) -> sum + term));
        HashSet<Integer> counts = new HashSet<Integer>(countsByIndex.values());
        int leastShards = Collections.min(counts);
        return Math.min(leastShards, 20);
    }

    private static <Request extends AbstractBulkByScrollRequest<Request>> void sendSubRequests(Client client, Action<Request, BulkByScrollResponse, ?> action, String localNodeId, BulkByScrollTask task, Request request, ActionListener<BulkByScrollResponse> listener) {
        LeaderBulkByScrollTaskState worker = task.getLeaderState();
        int totalSlices = worker.getSlices();
        TaskId parentTaskId = new TaskId(localNodeId, task.getId());
        for (SearchRequest slice : BulkByScrollParallelizationHelper.sliceIntoSubRequests(request.getSearchRequest(), "_id", totalSlices)) {
            Request requestForSlice = request.forSlice(parentTaskId, slice, totalSlices);
            ActionListener<BulkByScrollResponse> sliceListener = ActionListener.wrap(r -> worker.onSliceResponse(listener, slice.source().slice().getId(), (BulkByScrollResponse)r), e -> worker.onSliceFailure(listener, slice.source().slice().getId(), (Exception)e));
            client.execute(action, requestForSlice, sliceListener);
        }
    }

    static SearchRequest[] sliceIntoSubRequests(SearchRequest request, String field, int times) {
        SearchRequest[] slices = new SearchRequest[times];
        for (int slice = 0; slice < times; ++slice) {
            SearchSourceBuilder slicedSource;
            SliceBuilder sliceBuilder = new SliceBuilder(field, slice, times);
            if (request.source() == null) {
                slicedSource = new SearchSourceBuilder().slice(sliceBuilder);
            } else {
                if (request.source().slice() != null) {
                    throw new IllegalStateException("Can't slice a request that already has a slice configuration");
                }
                slicedSource = request.source().copyWithNewSlice(sliceBuilder);
            }
            SearchRequest searchRequest = new SearchRequest(request);
            searchRequest.source(slicedSource);
            slices[slice] = searchRequest;
        }
        return slices;
    }
}

