/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.reindex;

import conductor.org.apache.logging.log4j.Logger;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.index.IndexRequest;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.HandledTransportAction;
import conductor.org.elasticsearch.client.Client;
import conductor.org.elasticsearch.client.ParentTaskAssigningClient;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.index.VersionType;
import conductor.org.elasticsearch.index.reindex.AbstractAsyncBulkByScrollAction;
import conductor.org.elasticsearch.index.reindex.BulkByScrollParallelizationHelper;
import conductor.org.elasticsearch.index.reindex.BulkByScrollResponse;
import conductor.org.elasticsearch.index.reindex.BulkByScrollTask;
import conductor.org.elasticsearch.index.reindex.ScrollableHitSource;
import conductor.org.elasticsearch.index.reindex.UpdateByQueryAction;
import conductor.org.elasticsearch.index.reindex.UpdateByQueryRequest;
import conductor.org.elasticsearch.index.reindex.WorkerBulkByScrollTaskState;
import conductor.org.elasticsearch.script.Script;
import conductor.org.elasticsearch.script.ScriptService;
import conductor.org.elasticsearch.tasks.Task;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.util.Map;
import java.util.function.BiFunction;

public class TransportUpdateByQueryAction
extends HandledTransportAction<UpdateByQueryRequest, BulkByScrollResponse> {
    private final Client client;
    private final ScriptService scriptService;
    private final ClusterService clusterService;

    @Inject
    public TransportUpdateByQueryAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, TransportService transportService, ScriptService scriptService, ClusterService clusterService) {
        super(settings, "indices:data/write/update/byquery", threadPool, transportService, actionFilters, UpdateByQueryRequest::new, indexNameExpressionResolver);
        this.client = client;
        this.scriptService = scriptService;
        this.clusterService = clusterService;
    }

    @Override
    protected void doExecute(Task task, UpdateByQueryRequest request, ActionListener<BulkByScrollResponse> listener) {
        BulkByScrollTask bulkByScrollTask = (BulkByScrollTask)task;
        BulkByScrollParallelizationHelper.startSlicedAction(request, bulkByScrollTask, UpdateByQueryAction.INSTANCE, listener, this.client, this.clusterService.localNode(), () -> {
            ClusterState state = this.clusterService.state();
            ParentTaskAssigningClient assigningClient = new ParentTaskAssigningClient(this.client, this.clusterService.localNode(), bulkByScrollTask);
            new AsyncIndexBySearchAction(bulkByScrollTask, this.logger, assigningClient, this.threadPool, this, request, state, listener).start();
        });
    }

    @Override
    protected void doExecute(UpdateByQueryRequest request, ActionListener<BulkByScrollResponse> listener) {
        throw new UnsupportedOperationException("task required");
    }

    static class AsyncIndexBySearchAction
    extends AbstractAsyncBulkByScrollAction<UpdateByQueryRequest, TransportUpdateByQueryAction> {
        private final boolean allowSeqNoForCAS;

        AsyncIndexBySearchAction(BulkByScrollTask task, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, TransportUpdateByQueryAction action, UpdateByQueryRequest request, ClusterState clusterState, ActionListener<BulkByScrollResponse> listener) {
            super(task, true, clusterState.nodes().getMinNodeVersion().onOrAfter(Version.V_6_7_0), logger, client, threadPool, action, request, listener);
            this.allowSeqNoForCAS = clusterState.nodes().getMinNodeVersion().onOrAfter(Version.V_6_7_0);
        }

        @Override
        public BiFunction<AbstractAsyncBulkByScrollAction.RequestWrapper<?>, ScrollableHitSource.Hit, AbstractAsyncBulkByScrollAction.RequestWrapper<?>> buildScriptApplier() {
            Script script = ((UpdateByQueryRequest)this.mainRequest).getScript();
            if (script != null) {
                return new UpdateByQueryScriptApplier(this.worker, ((TransportUpdateByQueryAction)this.mainAction).scriptService, script, script.getParams());
            }
            return super.buildScriptApplier();
        }

        @Override
        protected AbstractAsyncBulkByScrollAction.RequestWrapper<IndexRequest> buildRequest(ScrollableHitSource.Hit doc) {
            IndexRequest index = new IndexRequest();
            index.index(doc.getIndex());
            index.type(doc.getType());
            index.id(doc.getId());
            index.source(doc.getSource(), doc.getXContentType());
            if (this.allowSeqNoForCAS && doc.getSeqNo() != -2L) {
                index.setIfSeqNo(doc.getSeqNo());
                index.setIfPrimaryTerm(doc.getPrimaryTerm());
            } else {
                assert (doc.getVersion() != -1L) : "no version retrieved";
                index.versionType(VersionType.INTERNAL);
                index.version(doc.getVersion());
            }
            index.setPipeline(((UpdateByQueryRequest)this.mainRequest).getPipeline());
            return AsyncIndexBySearchAction.wrap(index);
        }

        class UpdateByQueryScriptApplier
        extends AbstractAsyncBulkByScrollAction.ScriptApplier {
            UpdateByQueryScriptApplier(WorkerBulkByScrollTaskState taskWorker, ScriptService scriptService, Script script, Map<String, Object> params) {
                super(taskWorker, scriptService, script, params);
            }

            @Override
            protected void scriptChangedIndex(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_index] not allowed");
            }

            @Override
            protected void scriptChangedType(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_type] not allowed");
            }

            @Override
            protected void scriptChangedId(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_id] not allowed");
            }

            @Override
            protected void scriptChangedVersion(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_version] not allowed");
            }

            @Override
            protected void scriptChangedRouting(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_routing] not allowed");
            }

            @Override
            protected void scriptChangedParent(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_parent] not allowed");
            }
        }
    }
}

