/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.reindex.remote;

import conductor.org.apache.http.ContentTooLongException;
import conductor.org.apache.http.HttpEntity;
import conductor.org.apache.http.entity.ContentType;
import conductor.org.apache.http.util.EntityUtils;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.ElasticsearchStatusException;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.bulk.BackoffPolicy;
import conductor.org.elasticsearch.action.search.SearchRequest;
import conductor.org.elasticsearch.client.Request;
import conductor.org.elasticsearch.client.Response;
import conductor.org.elasticsearch.client.ResponseException;
import conductor.org.elasticsearch.client.ResponseListener;
import conductor.org.elasticsearch.client.RestClient;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.common.util.concurrent.AbstractRunnable;
import conductor.org.elasticsearch.common.util.concurrent.ThreadContext;
import conductor.org.elasticsearch.common.xcontent.DeprecationHandler;
import conductor.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.common.xcontent.XContentParseException;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import conductor.org.elasticsearch.index.reindex.ScrollableHitSource;
import conductor.org.elasticsearch.index.reindex.remote.RemoteRequestBuilders;
import conductor.org.elasticsearch.index.reindex.remote.RemoteResponseParsers;
import conductor.org.elasticsearch.rest.RestStatus;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class RemoteScrollableHitSource
extends ScrollableHitSource {
    private final RestClient client;
    private final BytesReference query;
    private final SearchRequest searchRequest;
    Version remoteVersion;

    public RemoteScrollableHitSource(Logger logger, BackoffPolicy backoffPolicy, ThreadPool threadPool, Runnable countSearchRetry, Consumer<Exception> fail, RestClient client, BytesReference query, SearchRequest searchRequest) {
        super(logger, backoffPolicy, threadPool, countSearchRetry, fail);
        this.query = query;
        this.searchRequest = searchRequest;
        this.client = client;
    }

    @Override
    protected void doStart(Consumer<? super ScrollableHitSource.Response> onResponse) {
        this.lookupRemoteVersion(version -> {
            this.remoteVersion = version;
            this.execute(RemoteRequestBuilders.initialSearch(this.searchRequest, this.query, this.remoteVersion), RemoteResponseParsers.RESPONSE_PARSER, r -> this.onStartResponse(onResponse, (ScrollableHitSource.Response)r));
        });
    }

    void lookupRemoteVersion(Consumer<Version> onVersion) {
        this.execute(new Request("GET", ""), RemoteResponseParsers.MAIN_ACTION_PARSER, onVersion);
    }

    private void onStartResponse(Consumer<? super ScrollableHitSource.Response> onResponse, ScrollableHitSource.Response response) {
        if (Strings.hasLength(response.getScrollId()) && response.getHits().isEmpty()) {
            this.logger.debug("First response looks like a scan response. Jumping right to the second. scroll=[{}]", (Object)response.getScrollId());
            this.doStartNextScroll(response.getScrollId(), TimeValue.timeValueMillis(0L), onResponse);
        } else {
            onResponse.accept(response);
        }
    }

    @Override
    protected void doStartNextScroll(String scrollId, TimeValue extraKeepAlive, Consumer<? super ScrollableHitSource.Response> onResponse) {
        TimeValue keepAlive = TimeValue.timeValueNanos(this.searchRequest.scroll().keepAlive().nanos() + extraKeepAlive.nanos());
        this.execute(RemoteRequestBuilders.scroll(scrollId, keepAlive, this.remoteVersion), RemoteResponseParsers.RESPONSE_PARSER, onResponse);
    }

    @Override
    protected void clearScroll(final String scrollId, final Runnable onCompletion) {
        this.client.performRequestAsync(RemoteRequestBuilders.clearScroll(scrollId, this.remoteVersion), new ResponseListener(){

            @Override
            public void onSuccess(Response response) {
                RemoteScrollableHitSource.this.logger.debug("Successfully cleared [{}]", (Object)scrollId);
                onCompletion.run();
            }

            @Override
            public void onFailure(Exception e) {
                this.logFailure(e);
                onCompletion.run();
            }

            private void logFailure(Exception e) {
                if (e instanceof ResponseException) {
                    ResponseException re = (ResponseException)e;
                    if (RemoteScrollableHitSource.this.remoteVersion.before(Version.fromId(2000099)) && re.getResponse().getStatusLine().getStatusCode() == 404) {
                        RemoteScrollableHitSource.this.logger.debug(() -> new ParameterizedMessage("Failed to clear scroll [{}] from pre-2.0 Elasticsearch. This is normal if the request terminated normally as the scroll has already been cleared automatically.", (Object)scrollId), (Throwable)e);
                        return;
                    }
                }
                RemoteScrollableHitSource.this.logger.warn(() -> new ParameterizedMessage("Failed to clear scroll [{}]", (Object)scrollId), (Throwable)e);
            }
        });
    }

    @Override
    protected void cleanup(Runnable onCompletion) {
        this.threadPool.generic().submit(() -> {
            try {
                this.client.close();
                this.logger.debug("Shut down remote connection");
            }
            catch (IOException e) {
                this.logger.error("Failed to shutdown the remote connection", (Throwable)e);
            }
            finally {
                onCompletion.run();
            }
        });
    }

    private <T> void execute(final Request request, final BiFunction<XContentParser, XContentType, T> parser, final Consumer<? super T> listener) {
        final Supplier<ThreadContext.StoredContext> contextSupplier = this.threadPool.getThreadContext().newRestorableContext(true);
        class RetryHelper
        extends AbstractRunnable {
            private final Iterator<TimeValue> retries;

            RetryHelper() {
                this.retries = RemoteScrollableHitSource.this.backoffPolicy.iterator();
            }

            @Override
            protected void doRun() throws Exception {
                RemoteScrollableHitSource.this.client.performRequestAsync(request, new ResponseListener(){

                    @Override
                    public void onSuccess(Response response) {
                        try (ThreadContext.StoredContext ctx = (ThreadContext.StoredContext)contextSupplier.get();){
                            Object parsedResponse;
                            assert (ctx != null);
                            try {
                                HttpEntity responseEntity = response.getEntity();
                                InputStream content = responseEntity.getContent();
                                XContentType xContentType = null;
                                if (responseEntity.getContentType() != null) {
                                    String mimeType = ContentType.parse(responseEntity.getContentType().getValue()).getMimeType();
                                    xContentType = XContentType.fromMediaType(mimeType);
                                }
                                if (xContentType == null) {
                                    try {
                                        throw new ElasticsearchException("Response didn't include Content-Type: " + RemoteScrollableHitSource.bodyMessage(response.getEntity()), new Object[0]);
                                    }
                                    catch (IOException e) {
                                        ElasticsearchException ee = new ElasticsearchException("Error extracting body from response", new Object[0]);
                                        ee.addSuppressed(e);
                                        throw ee;
                                    }
                                }
                                try (XContentParser xContentParser = xContentType.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, content);){
                                    parsedResponse = parser.apply(xContentParser, xContentType);
                                }
                                catch (XContentParseException e) {
                                    throw new ElasticsearchException("Error parsing the response, remote is likely not an Elasticsearch instance", (Throwable)e, new Object[0]);
                                }
                            }
                            catch (IOException e) {
                                throw new ElasticsearchException("Error deserializing response, remote is likely not an Elasticsearch instance", (Throwable)e, new Object[0]);
                            }
                            listener.accept(parsedResponse);
                        }
                    }

                    @Override
                    public void onFailure(Exception e) {
                        try (ThreadContext.StoredContext ctx = (ThreadContext.StoredContext)contextSupplier.get();){
                            assert (ctx != null);
                            if (e instanceof ResponseException) {
                                ResponseException re = (ResponseException)e;
                                if (RestStatus.TOO_MANY_REQUESTS.getStatus() == re.getResponse().getStatusLine().getStatusCode() && retries.hasNext()) {
                                    TimeValue delay = (TimeValue)retries.next();
                                    RemoteScrollableHitSource.this.logger.trace(() -> new ParameterizedMessage("retrying rejected search after [{}]", (Object)delay), (Throwable)e);
                                    RemoteScrollableHitSource.this.countSearchRetry.run();
                                    RemoteScrollableHitSource.this.threadPool.schedule(this, delay, "same");
                                    return;
                                }
                                e = RemoteScrollableHitSource.wrapExceptionToPreserveStatus(re.getResponse().getStatusLine().getStatusCode(), re.getResponse().getEntity(), re);
                            } else if (e instanceof ContentTooLongException) {
                                e = new IllegalArgumentException("Remote responded with a chunk that was too large. Use a smaller batch size.", e);
                            }
                            RemoteScrollableHitSource.this.fail.accept(e);
                        }
                    }
                });
            }

            @Override
            public void onFailure(Exception t) {
                RemoteScrollableHitSource.this.fail.accept(t);
            }
        }
        new RetryHelper().run();
    }

    static ElasticsearchStatusException wrapExceptionToPreserveStatus(int statusCode, @Nullable HttpEntity entity, Exception cause) {
        RestStatus status = RestStatus.fromCode(statusCode);
        String messagePrefix = "";
        if (status == null) {
            messagePrefix = "Couldn't extract status [" + statusCode + "]. ";
            status = RestStatus.INTERNAL_SERVER_ERROR;
        }
        try {
            return new ElasticsearchStatusException(messagePrefix + RemoteScrollableHitSource.bodyMessage(entity), status, cause, new Object[0]);
        }
        catch (IOException ioe) {
            ElasticsearchStatusException e = new ElasticsearchStatusException(messagePrefix + "Failed to extract body.", status, cause, new Object[0]);
            e.addSuppressed(ioe);
            return e;
        }
    }

    static String bodyMessage(@Nullable HttpEntity entity) throws IOException {
        if (entity == null) {
            return "No error body.";
        }
        return "body=" + EntityUtils.toString(entity);
    }
}

