/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.indices.recovery;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.transport.TransportRequest;
import java.io.IOException;

public class RecoveryFinalizeRecoveryRequest
extends TransportRequest {
    private long recoveryId;
    private ShardId shardId;
    private long globalCheckpoint;

    public RecoveryFinalizeRecoveryRequest() {
    }

    RecoveryFinalizeRecoveryRequest(long recoveryId, ShardId shardId, long globalCheckpoint) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.globalCheckpoint = globalCheckpoint;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public long globalCheckpoint() {
        return this.globalCheckpoint;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.recoveryId = in.readLong();
        this.shardId = ShardId.readShardId(in);
        this.globalCheckpoint = in.getVersion().onOrAfter(Version.V_6_0_0_alpha1) ? in.readZLong() : -2L;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_6_0_0_alpha1)) {
            out.writeZLong(this.globalCheckpoint);
        }
    }
}

