/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.indices.recovery;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.index.seqno.ReplicationTracker;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.transport.TransportRequest;
import java.io.IOException;

class RecoveryHandoffPrimaryContextRequest
extends TransportRequest {
    private long recoveryId;
    private ShardId shardId;
    private ReplicationTracker.PrimaryContext primaryContext;

    RecoveryHandoffPrimaryContextRequest() {
    }

    RecoveryHandoffPrimaryContextRequest(long recoveryId, ShardId shardId, ReplicationTracker.PrimaryContext primaryContext) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.primaryContext = primaryContext;
    }

    long recoveryId() {
        return this.recoveryId;
    }

    ShardId shardId() {
        return this.shardId;
    }

    ReplicationTracker.PrimaryContext primaryContext() {
        return this.primaryContext;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.recoveryId = in.readLong();
        this.shardId = ShardId.readShardId(in);
        this.primaryContext = new ReplicationTracker.PrimaryContext(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        this.primaryContext.writeTo(out);
    }

    public String toString() {
        return "RecoveryHandoffPrimaryContextRequest{recoveryId=" + this.recoveryId + ", shardId=" + this.shardId + ", primaryContext=" + this.primaryContext + '}';
    }
}

