/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest;

import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.rest.RestStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class RestResponse {
    protected Map<String, List<String>> customHeaders;

    public abstract String contentType();

    public abstract BytesReference content();

    public abstract RestStatus status();

    public void copyHeaders(ElasticsearchException ex) {
        Set<String> headerKeySet = ex.getHeaderKeys();
        if (this.customHeaders == null) {
            this.customHeaders = new HashMap<String, List<String>>(headerKeySet.size());
        }
        for (String key : headerKeySet) {
            List<String> values = this.customHeaders.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                this.customHeaders.put(key, values);
            }
            values.addAll(ex.getHeader(key));
        }
    }

    public void addHeader(String name, String value) {
        List<String> header;
        if (this.customHeaders == null) {
            this.customHeaders = new HashMap<String, List<String>>(2);
        }
        if ((header = this.customHeaders.get(name)) == null) {
            header = new ArrayList<String>();
            this.customHeaders.put(name, header);
        }
        header.add(value);
    }

    @Nullable
    public Map<String, List<String>> getHeaders() {
        return this.customHeaders;
    }
}

