/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.admin.indices;

import conductor.org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequest;
import conductor.org.elasticsearch.action.admin.indices.validate.query.ValidateQueryResponse;
import conductor.org.elasticsearch.action.support.IndicesOptions;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.ParsingException;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.BytesRestResponse;
import conductor.org.elasticsearch.rest.RestChannel;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.RestStatus;
import conductor.org.elasticsearch.rest.action.RestActions;
import conductor.org.elasticsearch.rest.action.RestToXContentListener;
import java.io.IOException;

public class RestValidateQueryAction
extends BaseRestHandler {
    public RestValidateQueryAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_validate/query", this);
        controller.registerHandler(RestRequest.Method.POST, "/_validate/query", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_validate/query", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_validate/query", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_validate/query", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_validate/query", this);
    }

    @Override
    public String getName() {
        return "validate_query_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ValidateQueryRequest validateQueryRequest = new ValidateQueryRequest(Strings.splitStringByCommaToArray(request.param("index")));
        validateQueryRequest.indicesOptions(IndicesOptions.fromRequest(request, validateQueryRequest.indicesOptions()));
        validateQueryRequest.explain(request.paramAsBoolean("explain", false));
        validateQueryRequest.types(Strings.splitStringByCommaToArray(request.param("type")));
        validateQueryRequest.rewrite(request.paramAsBoolean("rewrite", false));
        validateQueryRequest.allShards(request.paramAsBoolean("all_shards", false));
        Exception bodyParsingException = null;
        try {
            request.withContentOrSourceParamParserOrNull(parser -> {
                if (parser != null) {
                    validateQueryRequest.query(RestActions.getQueryContent(parser));
                } else if (request.hasParam("q")) {
                    validateQueryRequest.query(RestActions.urlParamsToQueryBuilder(request));
                }
            });
        }
        catch (Exception e) {
            bodyParsingException = e;
        }
        Exception finalBodyParsingException = bodyParsingException;
        return channel -> {
            if (finalBodyParsingException != null) {
                if (finalBodyParsingException instanceof ParsingException) {
                    this.handleException(validateQueryRequest, ((ParsingException)finalBodyParsingException).getDetailedMessage(), (RestChannel)channel);
                } else {
                    this.handleException(validateQueryRequest, finalBodyParsingException.getMessage(), (RestChannel)channel);
                }
            } else {
                client.admin().indices().validateQuery(validateQueryRequest, new RestToXContentListener<ValidateQueryResponse>((RestChannel)channel));
            }
        };
    }

    private void handleException(ValidateQueryRequest request, String message, RestChannel channel) throws IOException {
        channel.sendResponse(RestValidateQueryAction.buildErrorResponse(channel.newBuilder(), message, request.explain()));
    }

    private static BytesRestResponse buildErrorResponse(XContentBuilder builder, String error, boolean explain) throws IOException {
        builder.startObject();
        builder.field("valid", false);
        if (explain) {
            builder.field("error", error);
        }
        builder.endObject();
        return new BytesRestResponse(RestStatus.OK, builder);
    }
}

