/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.script;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.elasticsearch.index.fielddata.ScriptDocValues;
import conductor.org.elasticsearch.script.ScriptContext;
import conductor.org.elasticsearch.search.lookup.LeafSearchLookup;
import conductor.org.elasticsearch.search.lookup.SearchLookup;
import java.io.IOException;
import java.util.Map;

public abstract class FilterScript {
    public static final String[] PARAMETERS = new String[0];
    private final Map<String, Object> params;
    private final LeafSearchLookup leafLookup;
    public static final ScriptContext<Factory> CONTEXT = new ScriptContext<Factory>("filter", Factory.class);

    public FilterScript(Map<String, Object> params, SearchLookup lookup, LeafReaderContext leafContext) {
        this.params = params;
        this.leafLookup = lookup.getLeafSearchLookup(leafContext);
    }

    public abstract boolean execute();

    public Map<String, Object> getParams() {
        return this.params;
    }

    public final Map<String, ScriptDocValues<?>> getDoc() {
        return this.leafLookup.doc();
    }

    public void setDocument(int docid) {
        this.leafLookup.setDocument(docid);
    }

    public static interface Factory {
        public LeafFactory newFactory(Map<String, Object> var1, SearchLookup var2);
    }

    public static interface LeafFactory {
        public FilterScript newInstance(LeafReaderContext var1) throws IOException;
    }
}

