/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.composite;

import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.AggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactories;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import conductor.org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationFactory;
import conductor.org.elasticsearch.search.aggregations.bucket.composite.CompositeKey;
import conductor.org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import conductor.org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import conductor.org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceParserHelper;
import conductor.org.elasticsearch.search.aggregations.bucket.nested.NestedAggregatorFactory;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CompositeAggregationBuilder
extends AbstractAggregationBuilder<CompositeAggregationBuilder> {
    public static final String NAME = "composite";
    public static final ParseField AFTER_FIELD_NAME = new ParseField("after", new String[0]);
    public static final ParseField SIZE_FIELD_NAME = new ParseField("size", new String[0]);
    public static final ParseField SOURCES_FIELD_NAME = new ParseField("sources", new String[0]);
    private static final ObjectParser<CompositeAggregationBuilder, Void> PARSER = new ObjectParser("composite");
    private List<CompositeValuesSourceBuilder<?>> sources;
    private Map<String, Object> after;
    private int size = 10;

    public static CompositeAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        return PARSER.parse(parser, new CompositeAggregationBuilder(aggregationName), null);
    }

    private CompositeAggregationBuilder(String name) {
        this(name, null);
    }

    public CompositeAggregationBuilder(String name, List<CompositeValuesSourceBuilder<?>> sources) {
        super(name);
        this.sources = sources;
    }

    protected CompositeAggregationBuilder(CompositeAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.sources = new ArrayList(clone.sources);
        this.after = clone.after;
        this.size = clone.size;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new CompositeAggregationBuilder(this, factoriesBuilder, metaData);
    }

    public CompositeAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        int num = in.readVInt();
        this.sources = new ArrayList(num);
        for (int i = 0; i < num; ++i) {
            CompositeValuesSourceBuilder<?> builder = CompositeValuesSourceParserHelper.readFrom(in);
            this.sources.add(builder);
        }
        this.size = in.readVInt();
        if (in.readBoolean()) {
            this.after = in.readMap();
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.sources.size());
        for (CompositeValuesSourceBuilder<?> builder : this.sources) {
            CompositeValuesSourceParserHelper.writeTo(builder, out);
        }
        out.writeVInt(this.size);
        out.writeBoolean(this.after != null);
        if (this.after != null) {
            out.writeMap(this.after);
        }
    }

    @Override
    public String getType() {
        return NAME;
    }

    private CompositeAggregationBuilder setSources(List<CompositeValuesSourceBuilder<?>> sources) {
        this.sources = sources;
        return this;
    }

    public List<CompositeValuesSourceBuilder<?>> sources() {
        return this.sources;
    }

    public CompositeAggregationBuilder aggregateAfter(Map<String, Object> afterKey) {
        this.after = afterKey;
        return this;
    }

    public CompositeAggregationBuilder size(int size) {
        this.size = size;
        return this;
    }

    public int size() {
        return this.size;
    }

    private AggregatorFactory<?> checkParentIsNullOrNested(AggregatorFactory<?> factory) {
        if (factory == null) {
            return null;
        }
        if (factory instanceof NestedAggregatorFactory) {
            return this.checkParentIsNullOrNested(factory.getParent());
        }
        return factory;
    }

    @Override
    protected AggregatorFactory<?> doBuild(SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subfactoriesBuilder) throws IOException {
        CompositeKey afterKey;
        AggregatorFactory<?> invalid = this.checkParentIsNullOrNested(parent);
        if (invalid != null) {
            throw new IllegalArgumentException("[composite] aggregation cannot be used with a parent aggregation of type: [" + invalid.getClass().getSimpleName() + "]");
        }
        CompositeValuesSourceConfig[] configs = new CompositeValuesSourceConfig[this.sources.size()];
        for (int i = 0; i < configs.length; ++i) {
            configs[i] = this.sources.get(i).build(context);
            if (!configs[i].valuesSource().needsScores()) continue;
            throw new IllegalArgumentException("[sources] cannot access _score");
        }
        if (this.after != null) {
            if (this.after.size() != configs.length) {
                throw new IllegalArgumentException("[after] has " + this.after.size() + " value(s) but [sources] has " + this.sources.size());
            }
            Comparable[] values = new Comparable[this.sources.size()];
            for (int i = 0; i < this.sources.size(); ++i) {
                String sourceName = this.sources.get(i).name();
                if (!this.after.containsKey(sourceName)) {
                    throw new IllegalArgumentException("Missing value for [after." + this.sources.get(i).name() + "]");
                }
                Object obj = this.after.get(sourceName);
                if (configs[i].missingBucket() && obj == null) {
                    values[i] = null;
                    continue;
                }
                if (obj instanceof Comparable) {
                    values[i] = (Comparable)obj;
                    continue;
                }
                throw new IllegalArgumentException("Invalid value for [after." + this.sources.get(i).name() + "], expected comparable, got [" + (obj == null ? "null" : obj.getClass().getSimpleName()) + "]");
            }
            afterKey = new CompositeKey(values);
        } else {
            afterKey = null;
        }
        return new CompositeAggregationFactory(this.name, context, parent, subfactoriesBuilder, this.metaData, this.size, configs, afterKey);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SIZE_FIELD_NAME.getPreferredName(), this.size);
        builder.startArray(SOURCES_FIELD_NAME.getPreferredName());
        for (CompositeValuesSourceBuilder<?> source : this.sources) {
            CompositeValuesSourceParserHelper.toXContent(source, builder, params);
        }
        builder.endArray();
        if (this.after != null) {
            CompositeAggregation.buildCompositeMap(AFTER_FIELD_NAME.getPreferredName(), this.after, builder);
        }
        builder.endObject();
        return builder;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.sources, this.size, this.after);
    }

    @Override
    protected boolean doEquals(Object obj) {
        CompositeAggregationBuilder other = (CompositeAggregationBuilder)obj;
        return this.size == other.size && Objects.equals(this.sources, other.sources) && Objects.equals(this.after, other.after);
    }

    static {
        PARSER.declareInt(CompositeAggregationBuilder::size, SIZE_FIELD_NAME);
        PARSER.declareObject(CompositeAggregationBuilder::aggregateAfter, (parser, context) -> parser.map(), AFTER_FIELD_NAME);
        PARSER.declareObjectArray(CompositeAggregationBuilder::setSources, (p, c) -> CompositeValuesSourceParserHelper.fromXContent(p), SOURCES_FIELD_NAME);
    }
}

