/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.histogram;

import conductor.org.elasticsearch.common.CheckedFunction;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.rounding.Rounding;
import conductor.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.search.DocValueFormat;
import conductor.org.elasticsearch.search.SearchParseException;
import conductor.org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.Objects;

public class ExtendedBounds
implements ToXContentFragment,
Writeable {
    static final ParseField EXTENDED_BOUNDS_FIELD = Histogram.EXTENDED_BOUNDS_FIELD;
    static final ParseField MIN_FIELD = new ParseField("min", new String[0]);
    static final ParseField MAX_FIELD = new ParseField("max", new String[0]);
    public static final ConstructingObjectParser<ExtendedBounds, Void> PARSER = new ConstructingObjectParser("extended_bounds", a -> {
        assert (((Object[])a).length == 2);
        Long min = null;
        Long max = null;
        String minAsStr = null;
        String maxAsStr = null;
        if (a[0] != null) {
            if (a[0] instanceof Long) {
                min = (Long)a[0];
            } else if (a[0] instanceof String) {
                minAsStr = (String)a[0];
            } else {
                throw new IllegalArgumentException("Unknown field type [" + a[0].getClass() + "]");
            }
        }
        if (a[1] != null) {
            if (a[1] instanceof Long) {
                max = (Long)a[1];
            } else if (a[1] instanceof String) {
                maxAsStr = (String)a[1];
            } else {
                throw new IllegalArgumentException("Unknown field type [" + a[1].getClass() + "]");
            }
        }
        return new ExtendedBounds(min, max, minAsStr, maxAsStr);
    });
    private final Long min;
    private final Long max;
    private final String minAsStr;
    private final String maxAsStr;

    public ExtendedBounds(Long min, Long max) {
        this(min, max, null, null);
    }

    public ExtendedBounds(String minAsStr, String maxAsStr) {
        this(null, null, minAsStr, maxAsStr);
    }

    private ExtendedBounds(Long min, Long max, String minAsStr, String maxAsStr) {
        this.min = min;
        this.max = max;
        this.minAsStr = minAsStr;
        this.maxAsStr = maxAsStr;
    }

    public ExtendedBounds(StreamInput in) throws IOException {
        this.min = in.readOptionalLong();
        this.max = in.readOptionalLong();
        this.minAsStr = in.readOptionalString();
        this.maxAsStr = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalLong(this.min);
        out.writeOptionalLong(this.max);
        out.writeOptionalString(this.minAsStr);
        out.writeOptionalString(this.maxAsStr);
    }

    ExtendedBounds parseAndValidate(String aggName, SearchContext context, DocValueFormat format) {
        Long min = this.min;
        Long max = this.max;
        assert (format != null);
        if (this.minAsStr != null) {
            min = format.parseLong(this.minAsStr, false, context.getQueryShardContext()::nowInMillis);
        }
        if (this.maxAsStr != null) {
            max = format.parseLong(this.maxAsStr, false, context.getQueryShardContext()::nowInMillis);
        }
        if (min != null && max != null && min.compareTo(max) > 0) {
            throw new SearchParseException(context, "[extended_bounds.min][" + min + "] cannot be greater than [extended_bounds.max][" + max + "] for histogram aggregation [" + aggName + "]", null);
        }
        return new ExtendedBounds(min, max, this.minAsStr, this.maxAsStr);
    }

    ExtendedBounds round(Rounding rounding) {
        return new ExtendedBounds(this.min != null ? Long.valueOf(rounding.round(this.min)) : null, this.max != null ? Long.valueOf(rounding.round(this.max)) : null);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(EXTENDED_BOUNDS_FIELD.getPreferredName());
        if (this.min != null) {
            builder.field(MIN_FIELD.getPreferredName(), this.min);
        } else {
            builder.field(MIN_FIELD.getPreferredName(), this.minAsStr);
        }
        if (this.max != null) {
            builder.field(MAX_FIELD.getPreferredName(), this.max);
        } else {
            builder.field(MAX_FIELD.getPreferredName(), this.maxAsStr);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max, this.minAsStr, this.maxAsStr);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtendedBounds other = (ExtendedBounds)obj;
        return Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max) && Objects.equals(this.minAsStr, other.minAsStr) && Objects.equals(this.maxAsStr, other.maxAsStr);
    }

    public Long getMin() {
        return this.min;
    }

    public Long getMax() {
        return this.max;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.min != null) {
            b.append(this.min);
            if (this.minAsStr != null) {
                b.append('(').append(this.minAsStr).append(')');
            }
        } else if (this.minAsStr != null) {
            b.append(this.minAsStr);
        }
        b.append("--");
        if (this.max != null) {
            b.append(this.min);
            if (this.maxAsStr != null) {
                b.append('(').append(this.maxAsStr).append(')');
            }
        } else if (this.maxAsStr != null) {
            b.append(this.maxAsStr);
        }
        return b.toString();
    }

    static {
        CheckedFunction longOrString = p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return p.longValue(false);
            }
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return p.text();
            }
            if (p.currentToken() == XContentParser.Token.VALUE_NULL) {
                return null;
            }
            throw new IllegalArgumentException("Unsupported token [" + (Object)((Object)p.currentToken()) + "]");
        };
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), longOrString, MIN_FIELD, ObjectParser.ValueType.LONG_OR_NULL);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), longOrString, MAX_FIELD, ObjectParser.ValueType.LONG_OR_NULL);
    }
}

